/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLSRelation;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.cbtxstore.gls.LocallyCreatedRecord;
import org.ziniki.cbtxstore.gls.SetRelationAction;
import org.ziniki.cbtxstore.gls.SlotBindings;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.lowlevel.ExistingRecord;
import org.ziniki.tdastore.lowlevel.TDAUpsertHandler;
import org.ziniki.tdastore.support.UOWExecutor;
import org.ziniki.ziwsh.intf.ProvideIDOnCreate;

public class DoUpsert
implements SetRelationAction {
    public final Logger logger = LoggerFactory.getLogger((String)"GLS");
    private final String id;
    private final Object value;

    public DoUpsert(String id, Object value) {
        this.id = id;
        this.value = value;
        if (value instanceof ProvideIDOnCreate) {
            ((ProvideIDOnCreate)value).provideID(id);
        }
    }

    @Override
    public boolean updateLocalCreate(GLUnitOfWork uow) {
        if (!uow.has(this.id)) {
            return false;
        }
        ExistingRecord er = uow.getCB(this.id);
        if (er instanceof LocallyCreatedRecord) {
            ((LocallyCreatedRecord)er).updateWithValue(this.value);
            return true;
        }
        return false;
    }

    @Override
    public boolean forgetMe() {
        return false;
    }

    @Override
    public void invoke(TDAStorage storage, UOWExecutor exec, final GLUnitOfWork uow, GLSRelation couchbaseRelation, SlotBindings bindings) {
        storage.upsert((UnitOfWork)uow, this.id, this.value, new TDAUpsertHandler(){

            public void success() {
                uow.opDone(DoUpsert.this);
            }

            public void error(Throwable ex) {
                uow.fatalError(ex);
                uow.opDone(DoUpsert.this);
            }
        });
    }
}

