/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLRelationAction;
import org.ziniki.cbtxstore.gls.GLSRelation;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.cbtxstore.gls.InvocationStatus;
import org.ziniki.cbtxstore.gls.SlotBindings;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.lowlevel.ExistingRecord;
import org.ziniki.tdastore.lowlevel.RetrievedObject;
import org.ziniki.tdastore.lowlevel.TDARetrieveHandler;
import org.ziniki.tdastore.support.UOWExecutor;

public class DoGetList
implements GLRelationAction {
    public final Logger logger = LoggerFactory.getLogger((String)"GLS");
    private final String slot;
    private final List<String> ids;
    private boolean firedAll = false;

    public DoGetList(String slot, List<String> ids) {
        this.slot = slot;
        this.ids = ids;
    }

    @Override
    public boolean isReady(SlotBindings bindings) {
        return true;
    }

    @Override
    public InvocationStatus invoke(TDAStorage storage, UOWExecutor exec, GLUnitOfWork uow, GLSRelation couchbaseRelation, SlotBindings bindings) {
        if (this.ids == null || this.ids.isEmpty()) {
            bindings.bind(this.slot, new ArrayList());
            return InvocationStatus.COMPLETED;
        }
        InvocationStatus stat = InvocationStatus.COMPLETED;
        ArrayList ret = new ArrayList();
        AtomicInteger downTo = new AtomicInteger(this.ids.size());
        for (String s : this.ids) {
            int cnt = ret.size();
            ret.add(null);
            stat = this.fetch(stat, s, storage, exec, uow, retr -> this.stuff(uow, bindings, ret, cnt, retr, downTo));
        }
        this.firedAll = true;
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stuff(GLUnitOfWork uow, SlotBindings bindings, List<Object> ret, int cnt, Object retr, AtomicInteger downTo) {
        List<Object> list = ret;
        synchronized (list) {
            ret.set(cnt, retr);
            if (downTo.decrementAndGet() == 0) {
                bindings.bind(this.slot, ret);
                if (this.firedAll) {
                    uow.opDone(this);
                }
            }
        }
    }

    private InvocationStatus fetch(InvocationStatus stat, final String id, TDAStorage storage, UOWExecutor exec, final GLUnitOfWork uow, final Consumer<Object> stuffer) {
        if (uow.has(id)) {
            RetrievedObject fetched = (RetrievedObject)uow.getCB(id);
            Object retr = fetched.object();
            stuffer.accept(retr);
            return stat;
        }
        this.logger.info("Requesting " + id);
        storage.retrieve((UnitOfWork)uow, id, new TDARetrieveHandler(){

            public void notfound() {
                DoGetList.this.logger.info("id " + id + " was not found");
                Object retr = null;
                stuffer.accept(retr);
            }

            public <T> void found(RetrievedObject<T> retrieved) {
                DoGetList.this.logger.info("Retrieved " + id);
                Object retr = retrieved.object();
                uow.remember(id, (ExistingRecord)retrieved);
                stuffer.accept(retr);
            }

            public void error(Throwable ex) {
                DoGetList.this.logger.info("Error retrieving " + id, ex);
                uow.fatalError(ex);
                uow.opDone(DoGetList.this);
            }
        });
        return InvocationStatus.FIRED;
    }

    public String toString() {
        return "GetList" + this.ids;
    }
}

