/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLRelationAction;
import org.ziniki.cbtxstore.gls.GLSRelation;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.cbtxstore.gls.InvocationStatus;
import org.ziniki.cbtxstore.gls.SlotBindings;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.lowlevel.ExistingRecord;
import org.ziniki.tdastore.lowlevel.RetrievedObject;
import org.ziniki.tdastore.lowlevel.TDARetrieveHandler;
import org.ziniki.tdastore.support.UOWExecutor;

public class DoGet
implements GLRelationAction {
    public final Logger logger = LoggerFactory.getLogger((String)"GLS");
    private final String id;
    private final String slot;
    private final Function<Object, Object> filter;

    public DoGet(String slot, String id, Function<?, ?> filter) {
        if (id == null) {
            throw new NullPointerException("cannot retrieve " + slot + " with id null");
        }
        this.slot = slot;
        this.id = id;
        this.filter = filter;
    }

    @Override
    public boolean isReady(SlotBindings bindings) {
        return true;
    }

    @Override
    public InvocationStatus invoke(TDAStorage storage, UOWExecutor exec, final GLUnitOfWork uow, GLSRelation couchbaseRelation, final SlotBindings bindings) {
        if (uow.has(this.id)) {
            ExistingRecord fetched = uow.getCB(this.id);
            Object retr = fetched.object();
            if (this.filter != null && retr != null) {
                retr = this.filter.apply(retr);
            }
            bindings.bind(this.slot, retr);
            return InvocationStatus.COMPLETED;
        }
        this.logger.info("Requesting " + this.id);
        storage.retrieve((UnitOfWork)uow, this.id, new TDARetrieveHandler(){

            public void notfound() {
                DoGet.this.logger.info("id " + DoGet.this.id + " was not found");
                Object retr = null;
                if (DoGet.this.filter != null) {
                    retr = DoGet.this.filter.apply(null);
                }
                bindings.bind(DoGet.this.slot, retr);
                uow.opDone(DoGet.this);
            }

            public <T> void found(RetrievedObject<T> retrieved) {
                DoGet.this.logger.info("Retrieved " + DoGet.this.id);
                Object retr = retrieved.object();
                uow.remember(DoGet.this.id, (ExistingRecord)retrieved);
                if (DoGet.this.filter != null) {
                    retr = DoGet.this.filter.apply(retr);
                }
                bindings.bind(DoGet.this.slot, retr);
                uow.opDone(DoGet.this);
            }

            public void error(Throwable ex) {
                DoGet.this.logger.info("Error retrieving " + DoGet.this.id, ex);
                if (DoGet.this.filter != null) {
                    DoGet.this.filter.apply(null);
                }
                uow.fatalError(ex);
                uow.opDone(DoGet.this);
            }
        });
        return InvocationStatus.FIRED;
    }

    public String toString() {
        return "Get[" + this.slot + "<-" + this.id + "]";
    }
}

