/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLSRelation;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.cbtxstore.gls.LocallyCreatedRecord;
import org.ziniki.cbtxstore.gls.SetRelationAction;
import org.ziniki.cbtxstore.gls.SlotBindings;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.lowlevel.ExistingRecord;
import org.ziniki.tdastore.lowlevel.TDADeleteHandler;
import org.ziniki.tdastore.support.UOWExecutor;

public class DoDelete
implements SetRelationAction {
    public final Logger logger = LoggerFactory.getLogger((String)"GLS");
    private final String id;

    public DoDelete(String id) {
        this.id = id;
    }

    @Override
    public boolean updateLocalCreate(GLUnitOfWork uow) {
        ExistingRecord er;
        if (uow.has(this.id) && (er = uow.getCB(this.id)) instanceof LocallyCreatedRecord) {
            ((LocallyCreatedRecord)er).willBeDeleted();
            return true;
        }
        return false;
    }

    @Override
    public boolean forgetMe() {
        return false;
    }

    @Override
    public void invoke(TDAStorage storage, UOWExecutor exec, final GLUnitOfWork uow, GLSRelation couchbaseRelation, SlotBindings bindings) {
        storage.delete((UnitOfWork)uow, this.id, new TDADeleteHandler(){

            public void success() {
                uow.opDone(DoDelete.this);
            }

            public void error(Throwable ex) {
                uow.fatalError(ex);
                uow.opDone(DoDelete.this);
            }
        });
    }
}

