/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.tdastore.support.ThreadAwareUOW;
import org.ziniki.tdastore.support.UOWExecutor;
import org.zinutils.sync.LockingCounter;

public class CountDownExecutor
implements UOWExecutor {
    public final Logger logger = LoggerFactory.getLogger((String)"GLS");
    private final UOWExecutor exec;
    private final LockingCounter cdl;
    private CompletableFuture<TxError> onZero;

    public CountDownExecutor(UOWExecutor exec) {
        this.exec = exec;
        this.cdl = new LockingCounter();
    }

    public Executor getMain() {
        return this.exec.getMain();
    }

    public void execute(final ThreadAwareUOW uow, boolean willBlock, final Runnable runnable) {
        this.cdl.lock("logic");
        this.logger.info("Scheduling final logic: now " + this.cdl.getCount() + " still to finish");
        this.exec.execute(uow, willBlock, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CountDownExecutor.this.logger.info("Executing final logic with " + CountDownExecutor.this.cdl.getCount() + " still to finish");
                    runnable.run();
                }
                finally {
                    CountDownExecutor.this.cdl.release("logic");
                    CountDownExecutor.this.logger.info("Final logic ended: now " + CountDownExecutor.this.cdl.getCount() + " still to finish");
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        CountDownExecutor.this.logger.info("synchronized in execute complete: txc = " + CountDownExecutor.this.onZero + " and count is " + CountDownExecutor.this.cdl.getCount());
                        if (CountDownExecutor.this.cdl.getCount() == 0 && CountDownExecutor.this.onZero != null) {
                            CountDownExecutor.this.onZero.complete(((GLUnitOfWork)uow).state.fatalError);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOnDone(GLUnitOfWork uow) {
        CountDownExecutor countDownExecutor = this;
        synchronized (countDownExecutor) {
            CompletableFuture<TxError> txCompleted = uow.state.txCompleted;
            this.logger.info("synchronized in notifyOnDone: txc = " + txCompleted + " and count is " + this.cdl.getCount());
            this.onZero = txCompleted;
            if (this.cdl.getCount() == 0) {
                txCompleted.complete(uow.state.fatalError);
            }
        }
    }
}

