/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.BasePathMapping;
import software.amazon.awssdk.services.apigateway.model.ListOfBasePathMappingCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBasePathMappingsResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetBasePathMappingsResponse> {
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBasePathMappingsResponse.getter(GetBasePathMappingsResponse::position)).setter(GetBasePathMappingsResponse.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<List<BasePathMapping>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetBasePathMappingsResponse.getter(GetBasePathMappingsResponse::items)).setter(GetBasePathMappingsResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BasePathMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITION_FIELD, ITEMS_FIELD));
    private final String position;
    private final List<BasePathMapping> items;

    private GetBasePathMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.items = builder.items;
    }

    public String position() {
        return this.position;
    }

    public boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public List<BasePathMapping> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBasePathMappingsResponse)) {
            return false;
        }
        GetBasePathMappingsResponse other = (GetBasePathMappingsResponse)((Object)obj);
        return Objects.equals(this.position(), other.position()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        return ToString.builder((String)"GetBasePathMappingsResponse").add("Position", (Object)this.position()).add("Items", this.items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBasePathMappingsResponse, T> g) {
        return obj -> g.apply((GetBasePathMappingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String position;
        private List<BasePathMapping> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBasePathMappingsResponse model) {
            super(model);
            this.position(model.position);
            this.items(model.items);
        }

        public final String getPosition() {
            return this.position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Collection<BasePathMapping.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(BasePathMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<BasePathMapping> items) {
            this.items = ListOfBasePathMappingCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(BasePathMapping ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<BasePathMapping.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (BasePathMapping)((BasePathMapping.Builder)BasePathMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<BasePathMapping.BuilderImpl> items) {
            this.items = ListOfBasePathMappingCopier.copyFromBuilder(items);
        }

        @Override
        public GetBasePathMappingsResponse build() {
            return new GetBasePathMappingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBasePathMappingsResponse> {
        public Builder position(String var1);

        public Builder items(Collection<BasePathMapping> var1);

        public Builder items(BasePathMapping ... var1);

        public Builder items(Consumer<BasePathMapping.Builder> ... var1);
    }
}

