/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewaymanagementapi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Identity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Identity> {
    private static final SdkField<String> SOURCE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Identity.getter(Identity::sourceIp)).setter(Identity.setter(Builder::sourceIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIp").build()}).build();
    private static final SdkField<String> USER_AGENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Identity.getter(Identity::userAgent)).setter(Identity.setter(Builder::userAgent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAgent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IP_FIELD, USER_AGENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceIp;
    private final String userAgent;

    private Identity(BuilderImpl builder) {
        this.sourceIp = builder.sourceIp;
        this.userAgent = builder.userAgent;
    }

    public String sourceIp() {
        return this.sourceIp;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAgent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity other = (Identity)obj;
        return Objects.equals(this.sourceIp(), other.sourceIp()) && Objects.equals(this.userAgent(), other.userAgent());
    }

    public String toString() {
        return ToString.builder((String)"Identity").add("SourceIp", (Object)this.sourceIp()).add("UserAgent", (Object)this.userAgent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceIp": {
                return Optional.ofNullable(clazz.cast(this.sourceIp()));
            }
            case "UserAgent": {
                return Optional.ofNullable(clazz.cast(this.userAgent()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Identity, T> g) {
        return obj -> g.apply((Identity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceIp;
        private String userAgent;

        private BuilderImpl() {
        }

        private BuilderImpl(Identity model) {
            this.sourceIp(model.sourceIp);
            this.userAgent(model.userAgent);
        }

        public final String getSourceIp() {
            return this.sourceIp;
        }

        @Override
        public final Builder sourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        public final void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        public final String getUserAgent() {
            return this.userAgent;
        }

        @Override
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public Identity build() {
            return new Identity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Identity> {
        public Builder sourceIp(String var1);

        public Builder userAgent(String var1);
    }
}

