/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.tdastore.support;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import org.ziniki.tdastore.StorageOptions;

public abstract class CommonStorageOptions
implements StorageOptions {
    protected Date expiry;
    protected int expireAfter;
    protected TemporalUnit timeUnit;

    public StorageOptions expireAt(Date expiry) {
        this.expiry = expiry;
        return this;
    }

    public StorageOptions expireAfter(int expiry, TemporalUnit unit) {
        this.expireAfter = expiry;
        this.timeUnit = unit;
        return this;
    }

    public Duration expiryDuration() {
        if (this.expiry != null) {
            return Duration.between(Instant.now(), this.expiry.toInstant());
        }
        if (this.timeUnit != null) {
            return Duration.of(this.expireAfter, this.timeUnit);
        }
        return null;
    }
}

