/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.types;

import org.dmfs.httpessentials.types.Product;
import org.dmfs.httpessentials.types.SafeToken;
import org.dmfs.httpessentials.types.SimpleProduct;
import org.dmfs.httpessentials.types.Token;
import org.dmfs.httpessentials.types.Validate;

public final class VersionedProduct
implements Product {
    private final Product mProduct;
    private final Token mVersion;

    public VersionedProduct(Token name, Token version) {
        this.mProduct = new SimpleProduct(name);
        this.mVersion = Validate.notNull(version, "Version must not be null.");
    }

    public VersionedProduct(String name, String version) {
        this(new SafeToken(name), new SafeToken(version));
    }

    @Override
    public void appendTo(StringBuilder sb) {
        this.mProduct.appendTo(sb);
        sb.append("/");
        sb.append(this.mVersion);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }
}

