/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.types;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import org.dmfs.httpessentials.parameters.Parameter;
import org.dmfs.httpessentials.parameters.ParameterType;
import org.dmfs.httpessentials.parameters.Parametrized;
import org.dmfs.iterables.CsvIterable;
import org.dmfs.iterators.decorators.Sieved;
import org.dmfs.jems.iterator.decorators.Mapped;

public final class UrlFormEncodedKeyValues
implements Parametrized {
    private static final String ENCODING = "UTF-8";
    private static final char PAIR_SEPARATOR = '&';
    private static final char VALUE_SEPARATOR = '=';
    private final String mFormEncodedString;
    private final Iterable<String> mParts;

    public UrlFormEncodedKeyValues(String formEncodedString) {
        this.mFormEncodedString = formEncodedString;
        this.mParts = new CsvIterable(formEncodedString, '&');
    }

    public <T> Parameter<T> firstParameter(ParameterType<T> parameterType, T defaultValue) {
        Iterator<Parameter<T>> parameters = this.parameters(parameterType);
        return parameters.hasNext() ? parameters.next() : parameterType.entity(defaultValue);
    }

    public <T> Iterator<Parameter<T>> parameters(ParameterType<T> parameterType) {
        return new Mapped(element -> parameterType.entityFromString(element.getValue()), (Iterator)new Sieved(element -> parameterType.name().equals(element.getKey()), (Iterator)new Mapped(element -> new KeyValueStringEntry((String)element, element.indexOf(61)), this.mParts.iterator())));
    }

    public <T> boolean hasParameter(ParameterType<T> parameterType) {
        return this.parameters(parameterType).hasNext();
    }

    public String toString() {
        return this.mFormEncodedString;
    }

    private static class KeyValueStringEntry
    implements Map.Entry<String, String> {
        private final int mEqualsIdx;
        private final String mKeyValueString;

        public KeyValueStringEntry(String keyValueString, int equalsIdx) {
            this.mEqualsIdx = equalsIdx;
            this.mKeyValueString = keyValueString;
        }

        @Override
        public String getKey() {
            return this.decode(this.mEqualsIdx < 0 ? this.mKeyValueString : this.mKeyValueString.substring(0, this.mEqualsIdx));
        }

        @Override
        public String getValue() {
            return this.mEqualsIdx < 0 ? null : this.decode(this.mKeyValueString.substring(this.mEqualsIdx + 1));
        }

        @Override
        public String setValue(String s) {
            throw new UnsupportedOperationException("Setting the value of this Entry is not supported.");
        }

        private String decode(String string) {
            try {
                return URLDecoder.decode(string, UrlFormEncodedKeyValues.ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(String.format("Runtime doesn't support %s encoding", UrlFormEncodedKeyValues.ENCODING));
            }
        }
    }
}

