/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.types;

import java.util.Iterator;
import java.util.Locale;
import org.dmfs.httpessentials.parameters.Parameter;
import org.dmfs.httpessentials.parameters.ParameterType;
import org.dmfs.httpessentials.parameters.Parameters;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.iterators.decorators.Filtered;
import org.dmfs.iterators.elementary.Seq;
import org.dmfs.jems.iterator.decorators.Mapped;

public final class StructuredMediaType
implements MediaType {
    private final String mMainType;
    private final String mSubType;
    private final Parameter<?>[] mParameters;

    public StructuredMediaType(String maintype, String subtype) {
        this(maintype, subtype, false, new Parameter[0]);
    }

    public StructuredMediaType(String maintype, String subtype, String charset) {
        this(maintype, subtype, false, Parameters.CHARSET.entity((Object)charset));
    }

    public StructuredMediaType(String maintype, String subtype, Parameter<?> ... parameters) {
        this(maintype, subtype, true, parameters);
    }

    private StructuredMediaType(String maintype, String subtype, boolean cloneParameters, Parameter<?> ... parameters) {
        this.mMainType = maintype.toLowerCase(Locale.ENGLISH);
        this.mSubType = subtype.toLowerCase(Locale.ENGLISH);
        this.mParameters = cloneParameters ? (Parameter[])parameters.clone() : parameters;
    }

    public String type() {
        return this.mMainType + "/" + this.mSubType;
    }

    public String mainType() {
        return this.mMainType;
    }

    public String subType() {
        return this.mSubType;
    }

    public String charset(String defaultCharset) {
        return (String)this.firstParameter(Parameters.CHARSET, defaultCharset).value();
    }

    public <T> Parameter<T> firstParameter(ParameterType<T> parameterType, T defaultValue) {
        for (Parameter<?> param : this.mParameters) {
            if (!parameterType.equals((Object)param.type())) continue;
            return param;
        }
        return parameterType.entity(defaultValue);
    }

    public <T> Iterator<Parameter<T>> parameters(ParameterType<T> parameterType) {
        return new Mapped(element -> element, (Iterator)new Filtered((Iterator)new Seq((Object[])this.mParameters), element -> parameterType.equals(element.type())));
    }

    public <T> boolean hasParameter(ParameterType<T> parameterType) {
        for (Parameter<?> param : this.mParameters) {
            if (!parameterType.equals((Object)param.type())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.mMainType);
        result.append('/');
        result.append(this.mSubType);
        for (Parameter<?> param : this.mParameters) {
            result.append(';');
            result.append(param.type().name());
            result.append('=');
            result.append(param.toString());
        }
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return this.mMainType.equalsIgnoreCase(other.mainType()) && this.mSubType.equalsIgnoreCase(other.subType());
    }

    public int hashCode() {
        return this.mMainType.hashCode() * 31 + this.mSubType.hashCode();
    }
}

