/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.types;

import java.util.Arrays;
import java.util.Locale;
import org.dmfs.httpessentials.types.AbstractBaseToken;
import org.dmfs.httpessentials.types.CharToken;

public final class StringToken
extends AbstractBaseToken {
    private static final char[] SAFE_CHARS = "!#$%&'*+-.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ^_`abcdefghijklmnopqrstuvwxyz|~".toCharArray();

    public StringToken(CharSequence delegate) {
        super(new CharToken(new ValidatedCharSequence(delegate)));
    }

    private static final class ValidatedCharSequence
    implements CharSequence {
        private final CharSequence mDelegate;

        private ValidatedCharSequence(CharSequence delegate) {
            if (delegate.length() == 0) {
                throw new IllegalArgumentException("Tokens must not be empty.");
            }
            this.mDelegate = delegate;
        }

        @Override
        public int length() {
            return this.mDelegate.length();
        }

        @Override
        public char charAt(int i) {
            return this.validated(this.mDelegate.charAt(i));
        }

        @Override
        public CharSequence subSequence(int i, int i1) {
            return new ValidatedCharSequence(this.mDelegate.subSequence(i, i1));
        }

        @Override
        public String toString() {
            int len = this.mDelegate.length();
            for (int i = 0; i < len; ++i) {
                this.charAt(i);
            }
            return this.mDelegate.toString();
        }

        private char validated(char c) {
            if (Arrays.binarySearch(SAFE_CHARS, c) < 0) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Illegal character %c in token", Character.valueOf(c)));
            }
            return c;
        }
    }
}

