/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.types;

import java.util.Iterator;
import java.util.Locale;
import org.dmfs.httpessentials.parameters.Parameter;
import org.dmfs.httpessentials.parameters.ParameterType;
import org.dmfs.httpessentials.parameters.Parameters;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.iterables.CsvIterable;
import org.dmfs.iterators.Filter;
import org.dmfs.iterators.decorators.Filtered;
import org.dmfs.iterators.filters.Skip;
import org.dmfs.jems.iterator.decorators.Mapped;

public final class StringMediaType
implements MediaType {
    private static final char PARAMETER_SEPARATOR = ';';
    private static final char PARAMETER_VALUE_SEPARATOR = '=';
    private final String mMediaType;
    private final Iterable<String> mParts;

    public StringMediaType(String mediaType) {
        this.mMediaType = mediaType;
        this.mParts = new CsvIterable(this.mMediaType, ';');
    }

    public <T> Parameter<T> firstParameter(ParameterType<T> parameterType, T defaultValue) {
        Iterator<Parameter<T>> parameters = this.parameters(parameterType);
        return parameters.hasNext() ? parameters.next() : parameterType.entity(defaultValue);
    }

    public <T> Iterator<Parameter<T>> parameters(ParameterType<T> parameterType) {
        return new Mapped(element -> {
            int equalsIdx = element.indexOf(61);
            return parameterType.entityFromString(element.substring(equalsIdx + 1));
        }, (Iterator)new Filtered((Iterator)new Filtered(this.mParts.iterator(), (Filter)new Skip(1)), element -> {
            String param = element.trim();
            int equalsIdx = param.indexOf(61);
            return parameterType.name().equalsIgnoreCase(param.substring(0, equalsIdx));
        }));
    }

    public <T> boolean hasParameter(ParameterType<T> parameterType) {
        return this.parameters(parameterType).hasNext();
    }

    public String type() {
        return this.mParts.iterator().next().trim();
    }

    public String mainType() {
        String type = this.type();
        return type.substring(0, type.indexOf(47));
    }

    public String subType() {
        String type = this.type();
        int slash = type.indexOf(47);
        return this.mMediaType.substring(slash + 1, type.length());
    }

    public String charset(String defaultCharset) {
        return (String)this.firstParameter(Parameters.CHARSET, defaultCharset).value();
    }

    public String toString() {
        return this.mMediaType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return this.type().equalsIgnoreCase(other.type());
    }

    public int hashCode() {
        return this.mainType().toLowerCase(Locale.ENGLISH).hashCode() * 31 + this.subType().toLowerCase(Locale.ENGLISH).hashCode();
    }
}

