/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.types;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.dmfs.httpessentials.parameters.Parameter;
import org.dmfs.httpessentials.parameters.ParameterType;
import org.dmfs.httpessentials.parameters.Parameters;
import org.dmfs.httpessentials.types.Link;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.iterables.CsvIterable;
import org.dmfs.iterables.Repeatable;
import org.dmfs.iterators.CsvIterator;
import org.dmfs.iterators.Filter;
import org.dmfs.iterators.decorators.Filtered;
import org.dmfs.iterators.decorators.Sieved;
import org.dmfs.iterators.filters.Skip;
import org.dmfs.jems.iterator.decorators.Mapped;

public final class StringLink
implements Link {
    private static final char PARAMETER_SEPARATOR = ';';
    private static final char PARAMETER_VALUE_SEPARATOR = '=';
    private final String mLink;
    private final Iterable<String> mParts;

    public StringLink(String link) {
        this.mLink = link;
        this.mParts = this.mLink.length() > 200 ? new Repeatable((Iterator)new CsvIterator(this.mLink, ';')) : new CsvIterable(this.mLink, ';');
    }

    public <T> Parameter<T> firstParameter(ParameterType<T> parameterType, T defaultValue) {
        Iterator<Parameter<T>> parameters = this.parameters(parameterType);
        return parameters.hasNext() ? parameters.next() : parameterType.entity(defaultValue);
    }

    public <T> Iterator<Parameter<T>> parameters(ParameterType<T> parameterType) {
        return new Mapped(element -> {
            element = element.trim();
            int equalsIdx = element.indexOf(61);
            return parameterType.entityFromString(element.substring(equalsIdx + 1));
        }, (Iterator)new Sieved(element -> {
            String param = element.trim();
            int equalsIdx = param.indexOf(61);
            return parameterType.name().equalsIgnoreCase(param.substring(0, equalsIdx));
        }, (Iterator)new Filtered(this.mParts.iterator(), (Filter)new Skip(1))));
    }

    public <T> boolean hasParameter(ParameterType<T> parameterType) {
        return this.parameters(parameterType).hasNext();
    }

    public String toString() {
        return this.mLink;
    }

    @Override
    public URI target() {
        String target = this.mParts.iterator().next().trim();
        if (target.charAt(0) != '<' || target.charAt(target.length() - 1) != '>') {
            throw new IllegalArgumentException(String.format("%s is not properly enclosed by '<' and '>'", target));
        }
        return URI.create(target.substring(1, target.length() - 1));
    }

    @Override
    public URI context(URI defaultContext) {
        return defaultContext.resolve((URI)this.firstParameter(Parameters.ANCHOR, defaultContext).value());
    }

    @Override
    public Set<Locale> languages() {
        HashSet<Locale> result = new HashSet<Locale>(16);
        Iterator<Parameter<Locale>> locales = this.parameters(Parameters.HREFLANG);
        while (locales.hasNext()) {
            result.add((Locale)locales.next().value());
        }
        return result;
    }

    @Override
    public String title() {
        return (String)this.firstParameter(Parameters.TITLE, "").value();
    }

    @Override
    public MediaType mediaType() {
        return (MediaType)this.firstParameter(Parameters.TYPE, null).value();
    }

    @Override
    public Set<String> relationTypes() {
        return new HashSet<String>((Collection)this.firstParameter(Parameters.REL, Collections.emptyList()).value());
    }

    @Override
    public Set<String> reverseRelationTypes() {
        return new HashSet<String>((Collection)this.firstParameter(Parameters.REV, Collections.emptyList()).value());
    }
}

