/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.types;

import java.util.regex.Pattern;
import org.dmfs.httpessentials.types.AbstractStringType;
import org.dmfs.httpessentials.types.Comment;

public final class SimpleComment
extends AbstractStringType
implements Comment {
    private static final Pattern PATTERN_CTEXT_CHARS = Pattern.compile("[^\\u0009\\u0020-\\u0029\\u002A-\\u005B\\u005C\\u005D-\\u007E\\u0080-\\u00FF]");
    private static final Pattern PATTERN_ESCAPED_CHARS = Pattern.compile("([\\(\\)\\\\])");

    public SimpleComment(String commentContent) {
        super(commentContent == null ? null : SimpleComment.makeItStandardCompliant(commentContent));
    }

    private static String makeItStandardCompliant(String value) {
        String replaced = PATTERN_ESCAPED_CHARS.matcher(PATTERN_CTEXT_CHARS.matcher(value).replaceAll("_")).replaceAll("\\\\$1");
        return "(" + replaced + ")";
    }
}

