/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.types;

import java.util.Arrays;
import org.dmfs.httpessentials.types.AbstractBaseToken;
import org.dmfs.httpessentials.types.CharToken;

public final class SafeToken
extends AbstractBaseToken {
    private static final char[] SAFE_CHARS = "!#$%&'*+-.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ^_`abcdefghijklmnopqrstuvwxyz|~".toCharArray();

    public SafeToken(String delegate) {
        this((CharSequence)delegate);
    }

    public SafeToken(CharSequence delegate) {
        super(new CharToken(new SafeCharSequence(delegate)));
    }

    private static final class SafeCharSequence
    implements CharSequence {
        private final CharSequence mDelegate;

        private SafeCharSequence(CharSequence delegate) {
            if (delegate.length() == 0) {
                throw new IllegalArgumentException("Tokens must not be empty.");
            }
            this.mDelegate = delegate;
        }

        @Override
        public int length() {
            return this.mDelegate.length();
        }

        @Override
        public char charAt(int i) {
            return this.safe(this.mDelegate.charAt(i));
        }

        @Override
        public CharSequence subSequence(int i, int i1) {
            return new SafeCharSequence(this.mDelegate.subSequence(i, i1));
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.length());
            int len = this.mDelegate.length();
            for (int i = 0; i < len; ++i) {
                stringBuilder.append(this.safe(this.charAt(i)));
            }
            return stringBuilder.toString();
        }

        private char safe(char c) {
            return Arrays.binarySearch(SAFE_CHARS, c) < 0 ? (char)'_' : (char)c;
        }
    }
}

