/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.types;

import org.dmfs.httpessentials.types.Comment;
import org.dmfs.httpessentials.types.Product;
import org.dmfs.httpessentials.types.SafeToken;
import org.dmfs.httpessentials.types.SimpleComment;
import org.dmfs.httpessentials.types.SimpleProduct;
import org.dmfs.httpessentials.types.Token;
import org.dmfs.httpessentials.types.Validate;
import org.dmfs.httpessentials.types.VersionedProduct;

public final class CommentedProduct
implements Product {
    private final Product mProduct;
    private final Comment mComment;

    public CommentedProduct(Token name, Token version, Comment comment) {
        this(new VersionedProduct(name, version), comment);
    }

    public CommentedProduct(String name, String version, String comment) {
        this(new VersionedProduct(new SafeToken(name), new SafeToken(version)), (Comment)new SimpleComment(comment));
    }

    public CommentedProduct(Token name, Comment comment) {
        this(new SimpleProduct(name), comment);
    }

    public CommentedProduct(String name, String comment) {
        this(new SimpleProduct(new SafeToken(name)), (Comment)new SimpleComment(comment));
    }

    private CommentedProduct(Product product, Comment comment) {
        this.mProduct = product;
        this.mComment = Validate.notNull(comment, "Comment must not be null.");
    }

    @Override
    public void appendTo(StringBuilder sb) {
        this.mProduct.appendTo(sb);
        sb.append(" ");
        sb.append(this.mComment);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }
}

