/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.parameters;

import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.dmfs.httpessentials.converters.LanguageTagConverter;
import org.dmfs.httpessentials.converters.MediaTypeConverter;
import org.dmfs.httpessentials.converters.OptionallyQuoted;
import org.dmfs.httpessentials.converters.PlainStringHeaderConverter;
import org.dmfs.httpessentials.converters.Quoted;
import org.dmfs.httpessentials.converters.RegexpSplitListConverter;
import org.dmfs.httpessentials.converters.UriConverter;
import org.dmfs.httpessentials.parameters.BasicParameterType;
import org.dmfs.httpessentials.parameters.ParameterType;
import org.dmfs.httpessentials.typedentity.EntityConverter;
import org.dmfs.httpessentials.types.MediaType;

public final class Parameters {
    public static final ParameterType<MediaType> TYPE = new BasicParameterType<MediaType>("type", new OptionallyQuoted<MediaType>(MediaTypeConverter.INSTANCE));
    public static final ParameterType<Locale> HREFLANG = new BasicParameterType<Locale>("hreflang", LanguageTagConverter.INSTANCE);
    public static final ParameterType<URI> ANCHOR = new BasicParameterType<URI>("anchor", new Quoted<URI>(UriConverter.INSTANCE));
    public static final ParameterType<List<String>> REL = new BasicParameterType<String>("rel", new OptionallyQuoted<String>(new RegexpSplitListConverter<String>(PlainStringHeaderConverter.INSTANCE, Pattern.compile("\\s+"), " ")));
    public static final ParameterType<List<String>> REV = new BasicParameterType<String>("rev", new OptionallyQuoted<String>(new RegexpSplitListConverter<String>(PlainStringHeaderConverter.INSTANCE, Pattern.compile("\\s+"), " ")));
    private static final EntityConverter<String> OPTIONALLY_QUOTED_TEXT = new OptionallyQuoted<String>(PlainStringHeaderConverter.INSTANCE);
    public static final ParameterType<String> CHARSET = new BasicParameterType<String>("charset", OPTIONALLY_QUOTED_TEXT);
    public static final ParameterType<String> TITLE = new BasicParameterType<String>("title", OPTIONALLY_QUOTED_TEXT);

    private Parameters() {
    }
}

