/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.dmfs.httpessentials.typedentity.EntityConverter;

public final class RegexpSplitListConverter<T>
implements EntityConverter<List<T>> {
    private final EntityConverter<T> mConverter;
    private final Pattern mDividerPattern;
    private final CharSequence mDivider;

    public RegexpSplitListConverter(EntityConverter<T> converter, Pattern dividerPattern, CharSequence divider) {
        this.mConverter = converter;
        this.mDividerPattern = dividerPattern;
        this.mDivider = divider;
    }

    public List<T> value(String valueString) {
        ArrayList<Object> result = new ArrayList<Object>(16);
        for (String value : this.mDividerPattern.split(valueString)) {
            result.add(this.mConverter.value(value));
        }
        return result;
    }

    public String valueString(List<T> elements) {
        StringBuilder result = new StringBuilder(elements.size() * 30);
        boolean first = true;
        for (T element : elements) {
            if (first) {
                first = false;
            } else {
                result.append(this.mDivider);
            }
            result.append(this.mConverter.valueString(element));
        }
        return result.toString();
    }
}

