/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.converters;

import org.dmfs.httpessentials.typedentity.EntityConverter;

public final class Quoted<E>
implements EntityConverter<E> {
    private final EntityConverter<E> mDelegate;

    public Quoted(EntityConverter<E> delegate) {
        this.mDelegate = delegate;
    }

    public E value(String quotedString) {
        String trimmed = quotedString.trim();
        if (trimmed.length() <= 1 || trimmed.charAt(0) != '\"' || trimmed.charAt(trimmed.length() - 1) != '\"') {
            throw new IllegalArgumentException(String.format("%s is not a properly quoted string.", quotedString));
        }
        return (E)this.mDelegate.value(trimmed.substring(1, trimmed.length() - 1).replace("\\\\", "\\").replace("\\\"", "\""));
    }

    public String valueString(E value) {
        return "\"" + this.mDelegate.valueString(value).replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
    }
}

