/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.converters;

import org.dmfs.httpessentials.typedentity.EntityConverter;

public final class PlainStringHeaderConverter
implements EntityConverter<String> {
    public static final PlainStringHeaderConverter INSTANCE = new PlainStringHeaderConverter();

    public String value(String headerValueString) {
        return headerValueString.trim();
    }

    public String valueString(String headerValue) {
        int count = headerValue.length();
        for (int i = 0; i < count; ++i) {
            char c = headerValue.charAt(i);
            if (c >= ' ' && c <= '\u00ff' || c == '\t') continue;
            throw new IllegalArgumentException(String.format("String '%s' contains non-printable or non-ASCII characters, which is not allowed in headers", headerValue));
        }
        return headerValue;
    }
}

