/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.converters;

import java.util.ArrayList;
import java.util.List;
import org.dmfs.httpessentials.typedentity.EntityConverter;
import org.dmfs.iterators.CsvIterator;

public final class ListConverter<T>
implements EntityConverter<List<T>> {
    private static final char DEFAULT_DIVIDER = ',';
    private final EntityConverter<T> mConverter;
    private final char mDivider;

    public ListConverter(EntityConverter<T> converter) {
        this(converter, ',');
    }

    public ListConverter(EntityConverter<T> converter, char divider) {
        this.mConverter = converter;
        this.mDivider = divider;
    }

    public List<T> value(String valueString) {
        ArrayList<Object> result = new ArrayList<Object>(16);
        CsvIterator iterator = new CsvIterator(valueString, this.mDivider);
        while (iterator.hasNext()) {
            result.add(this.mConverter.value(((String)iterator.next()).trim()));
        }
        return result;
    }

    public String valueString(List<T> elements) {
        StringBuilder result = new StringBuilder(elements.size() * 30);
        boolean first = true;
        for (T element : elements) {
            if (first) {
                first = false;
            } else {
                result.append(this.mDivider);
            }
            result.append(this.mConverter.valueString(element));
        }
        return result.toString();
    }
}

