/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.grizzly;

import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.Beachhead;
import org.ziniki.ziwsh.intf.EntryId;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.JsonSender;
import org.ziniki.ziwsh.intf.Param;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.intf.WebSocketFinder;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.JsonBeachhead;

public class GrizzlyConnectionStore
implements WebSocketFinder {
    private static final Logger logger = LoggerFactory.getLogger((String)"Grizzly");
    private final Map<String, GrizzlyEntry> handlers = new TreeMap<String, GrizzlyEntry>();
    private final ZiwshBroker zb;
    private final ClassLoader loader = GrizzlyConnectionStore.class.getClassLoader();

    public GrizzlyConnectionStore(@Param(value="broker") ZiwshBroker zb) {
        this.zb = zb;
    }

    public void remember(EvalContext cx, String tok, EntryId mytok, String secret, WSResponder responder) {
        JsonBeachhead srvBeach = new JsonBeachhead((WebSocketFinder)this, this.zb.creator(), "srv", (JsonSender)responder, this.zb, null, this.loader);
        logger.info("Remembering web socket connection: " + tok);
        this.handlers.put(tok, new GrizzlyEntry(secret, responder, (Beachhead)srvBeach));
    }

    public WebSocketFinder.Entry find(String tok, EntryId _tok) {
        logger.info("Trying to find web socket for " + tok);
        return this.handlers.get(tok);
    }

    public class GrizzlyEntry
    implements WebSocketFinder.Entry {
        private final String secret;
        private final Beachhead srvBeach;
        private final WSResponder responder;

        public GrizzlyEntry(String secret, WSResponder responder, Beachhead srvBeach) {
            this.secret = secret;
            this.responder = responder;
            this.srvBeach = srvBeach;
        }

        public Beachhead beachhead() {
            return this.srvBeach;
        }

        public WSResponder responder() {
            return this.responder;
        }

        public boolean secretIs(String secret) {
            return this.secret.equals(secret);
        }

        public void dispatch(EvalContext cx, String text) {
            this.srvBeach.dispatch(cx, text, this.responder);
        }
    }
}

