/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.compiler.upload;

import java.awt.Desktop;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.codehaus.jettison.json.JSONObject;
import org.flasck.flas.Configuration;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.compiler.jsgen.packaging.JSEnvironment;
import org.flasck.flas.compiler.modules.CompilerComplete;
import org.flasck.flas.compiler.modules.PreCompilationModule;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.container.FLASBroker;
import org.flasck.jvm.fl.ClientEnvironment;
import org.flasck.jvm.ziniki.ContentObject;
import org.flasck.jvm.ziniki.PackageSources;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ContentProvider;
import org.ziniki.ContentStore;
import org.ziniki.FileProvider;
import org.ziniki.compiler.options.ZinikiOptions;
import org.ziniki.compiler.upload.HttpAnswer;
import org.ziniki.compiler.upload.HttpClientExecutor;
import org.ziniki.compiler.upload.HttpExecutor;
import org.ziniki.compiler.upload.OnLogin;
import org.ziniki.ziwsh.intf.ConnectTo;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.jvm.ConnectToWSAPI;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.exceptions.ZinikiHttpException;
import org.zinutils.inabox.grizzly.AcceptorProcessor;
import org.zinutils.inabox.grizzly.Grizzly;
import org.zinutils.inabox.grizzly.actors.GrizzlyBuilder;
import org.zinutils.inabox.grizzly.actors.GrizzlyEndpoint;
import org.zinutils.utils.FileUtils;

public class Uploader
implements PreCompilationModule,
CompilerComplete,
AutoCloseable {
    private static final int MS_TIMEOUT = 15000;
    private static final Logger logger = LoggerFactory.getLogger((String)"Uploader");
    private org.ziniki.Uploader uploader;
    private FLEvalContext cx;
    private ContentStore contentstore;
    private HttpExecutor cli;
    private FLASBroker broker;

    public static void main(String[] argv) throws Exception {
        if (argv.length < 4) {
            throw new InvalidUsageException("Usage: Uploader [--flascklib ziniki-uri ziniki-ws <dir>] | [--modulelib ziniki-uri ziniki-ws <name> <dir>]");
        }
        switch (argv[0]) {
            case "--flascklib": {
                try (Uploader uploader = new Uploader();){
                    uploader.makeConnection(argv[1], argv[2]);
                    uploader.uploadFlasckLib(new File(argv[3]), true);
                    uploader.cx.close();
                    break;
                }
            }
            case "--modulelib": {
                if (argv.length < 5) {
                    throw new InvalidUsageException("Usage: Uploader --modulelib ziniki-uri ziniki-ws <name> <dir>");
                }
                try (Uploader uploader = new Uploader();){
                    uploader.makeConnection(argv[1], argv[2]);
                    uploader.uploadModuleLib(argv[3], new File(argv[4]), true);
                    break;
                }
            }
            default: {
                throw new InvalidUsageException("Usage: Uploader [--builtins]");
            }
        }
        System.exit(0);
    }

    public boolean preCompilation(Configuration config) throws Exception {
        ZinikiOptions opts = (ZinikiOptions)config.getOptionsModule(ZinikiOptions.class);
        if (opts == null) {
            return true;
        }
        if (opts.ziniki != null && opts.uploadTag != null) {
            if ("flasck".equals(opts.uploadTag)) {
                Uploader.uploadFlasckLib(opts.ziniki, opts.wsapi, opts.uploadDir);
            } else {
                Uploader.uploadModule(opts.ziniki, opts.wsapi, opts.uploadTag, opts.uploadDir);
            }
            return false;
        }
        return true;
    }

    public static void uploadFlasckLib(String ziniki, String wsapi, File flasckdir) throws Exception {
        try (Uploader uploader = new Uploader();){
            uploader.makeConnection(ziniki, wsapi);
            uploader.uploadFlasckLib(flasckdir, true);
            uploader.cx.close();
        }
    }

    public static void uploadModule(String ziniki, String wsapi, String module, File fromdir) throws Exception {
        try (Uploader uploader = new Uploader();){
            uploader.makeConnection(ziniki, wsapi);
            uploader.uploadModuleLib(module, fromdir, true);
        }
    }

    public void setHttpClient(HttpExecutor cli) {
        this.cli = cli;
    }

    public void complete(ErrorReporter errors, Configuration config, List<PackageSources> packages, ByteCodeEnvironment jvm, JSEnvironment jse) {
        ZinikiOptions opts = (ZinikiOptions)config.getOptionsModule(ZinikiOptions.class);
        if (opts == null) {
            return;
        }
        if (opts.ziniki != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String version = sdf.format(new Date());
            try {
                try {
                    this.makeConnection(opts.ziniki, opts.wsapi);
                }
                catch (Exception ex) {
                    ex = WrappedException.unwrapAny((Exception)ex);
                    if (ex.getMessage() != null) {
                        errors.message((InputPosition)null, ex.getMessage());
                    } else {
                        errors.message((InputPosition)null, ex.toString());
                    }
                    return;
                }
                ArrayList<ContentObject> cos = new ArrayList<ContentObject>();
                for (File wz : config.webs) {
                    this.storeWebZip(cos, wz);
                }
                for (PackageSources ps : packages) {
                    ArrayList<String> deps = new ArrayList<String>();
                    for (String s : jse.packages()) {
                        if (s.contains("._") || ps.getPackageName().equals(s)) continue;
                        deps.add(s);
                    }
                    ArrayList<String> modules = new ArrayList<String>();
                    for (File m : config.modules) {
                        modules.add(m.getName());
                    }
                    this.createPackage(ps.getPackageName(), version, modules, deps);
                    this.uploadWebZips(ps.getPackageName(), version, cos);
                    this.upload(ps.getPackageName(), version, "sources", ps.sources());
                    this.upload(ps.getPackageName(), version, "unitTests", ps.unitTests());
                    this.upload(ps.getPackageName(), version, "assemblies", ps.assemblies());
                    this.upload(ps.getPackageName(), version, "systemTests", ps.systemTests());
                    this.deploy(ps.getPackageName(), version);
                }
            }
            catch (Exception ex) {
                ex = WrappedException.unwrapAny((Exception)ex);
                if (ex instanceof ConnectException) {
                    errors.message((InputPosition)null, "Could not connect to Ziniki at " + opts.ziniki);
                }
                logger.info("error uploading to Ziniki", (Throwable)ex);
                errors.message((InputPosition)null, "Error uploading to Ziniki: " + ex.toString());
            }
        }
    }

    private void makeConnection(String zinikiUri, String wsapi) throws Exception {
        String[] ts = this.ensureValidToken(zinikiUri);
        logger.info("uploading to ziniki " + wsapi + " with " + ts[0]);
        URI wsuri = URI.create(wsapi);
        SSLEngineConfigurator tlsStore = GrizzlyBuilder.initializeSSLAsAVeryTrustingClient();
        ClientEnvironment cliEnv = new ClientEnvironment();
        FLASBroker broker = (FLASBroker)cliEnv.getBroker();
        broker.connectBeachhead((ConnectTo)new ConnectToWSAPI(wsuri, ts[0], ts[1]), tlsStore);
        if (!broker.successfullyConnected()) {
            throw new RuntimeException("Ziniki refused connection");
        }
        logger.info("Ziniki accepted connection");
        this.init(cliEnv);
    }

    private String[] ensureValidToken(String zinikiUri) throws Exception {
        String[] ts = this.getCurrentToken();
        if (ts == null) {
            logger.info("no token at all");
            ts = new String[]{"null", "null"};
        }
        logger.info("checking token " + ts[0] + " on ziniki " + zinikiUri);
        HttpAnswer isValid = this.execute((HttpUriRequest)new HttpGet(zinikiUri + "/valid/" + ts[0] + "/" + ts[1]));
        if (isValid.isLoggedIn()) {
            return ts;
        }
        logger.info("token is not valid");
        String desktopUri = isValid.getDesktopUri();
        OnLogin waitForLogin = new OnLogin(desktopUri);
        GrizzlyEndpoint grizzly = Grizzly.acceptor((int)0, (AcceptorProcessor)waitForLogin).build();
        Desktop.getDesktop().browse(URI.create(desktopUri + "?callback=" + URLEncoder.encode(grizzly.uri(), Charset.forName("UTF-8"))));
        ts = waitForLogin.waitForCredentials();
        if (ts == null) {
            throw new RuntimeException("could not connect to Ziniki");
        }
        this.saveToken(ts);
        return ts;
    }

    private String[] getCurrentToken() {
        String home = System.getProperty("user.home");
        if (home == null) {
            logger.info("no home directory");
            return null;
        }
        File f = new File(home, ".zintok");
        try {
            String all = FileUtils.readFile((File)f);
            JSONObject json = new JSONObject(all);
            return new String[]{json.getString("token"), json.getString("secret")};
        }
        catch (Exception ex) {
            logger.debug("could not read ~/.zintok" + ex);
            return null;
        }
    }

    private void saveToken(String[] ts) {
        String home = System.getProperty("user.home");
        if (home == null) {
            logger.info("no home directory");
            return;
        }
        try {
            File f = new File(home, ".zintok");
            JSONObject json = new JSONObject();
            json.put("token", (Object)ts[0]);
            json.put("secret", (Object)ts[1]);
            FileUtils.writeFile((File)f, (String)json.toString());
        }
        catch (Exception ex) {
            logger.info("could not save to .zintok: " + ex.toString());
        }
    }

    public void init(ClientEnvironment cliEnv) {
        this.broker = (FLASBroker)cliEnv.getBroker();
        this.uploader = (org.ziniki.Uploader)this.broker.require(org.ziniki.Uploader.class);
        this.contentstore = (ContentStore)this.broker.require(ContentStore.class);
        this.cx = cliEnv.create();
    }

    public void provideServices(FLEvalContext cx, ContentStore cs, org.ziniki.Uploader usvc) {
        this.cx = cx;
        this.contentstore = cs;
        this.uploader = usvc;
    }

    public void uploadFlasckLib(File dir, boolean andWait) throws ClientProtocolException, TimeoutException, IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String version = sdf.format(new Date());
        List<ContentObject> mainjs = this.uploadSet("runtime", version, new File(dir, "main"), "");
        List<ContentObject> livejs = this.uploadSet("runtime", version, new File(dir, "live"), "/live");
        List<ContentObject> testjs = this.uploadSet("runtime", version, new File(dir, "test"), "/test");
        LatchedHandler lih = new LatchedHandler();
        logger.info("uploading flasck lib meta info");
        this.uploader.provideFlasckLib(this.cx, new Object[]{version, mainjs, livejs, testjs, lih});
        if (andWait) {
            lih.waitFor(15000L, TimeUnit.MILLISECONDS);
        }
    }

    public void uploadModuleLib(String name, File dir, boolean andWait) throws ClientProtocolException, TimeoutException, IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String version = sdf.format(new Date());
        List<ContentObject> mainjs = this.uploadSet("modules/" + name, version, new File(dir, "main"), "");
        List<ContentObject> livejs = this.uploadSet("modules/" + name, version, new File(dir, "live"), "/live");
        List<ContentObject> testjs = this.uploadSet("modules/" + name, version, new File(dir, "test"), "/test");
        LatchedHandler lih = new LatchedHandler();
        logger.info("uploading module lib meta info");
        this.uploader.provideModuleLib(this.cx, new Object[]{name, version, mainjs, livejs, testjs, lih});
        if (andWait) {
            lih.waitFor(15000L, TimeUnit.MILLISECONDS);
        }
    }

    private List<ContentObject> uploadSet(String name, String version, File setdir, String subdir) throws TimeoutException, ClientProtocolException, IOException {
        ArrayList<ContentObject> ret = new ArrayList<ContentObject>();
        if (setdir.isDirectory()) {
            File[] files = setdir.listFiles();
            ArrayList<String> larr = new ArrayList<String>();
            for (File f : files) {
                if (!f.isFile() || !f.getName().endsWith(".js")) continue;
                larr.add(FileUtils.dropExtension((String)f.getName()));
            }
            String[] names = larr.toArray(new String[larr.size()]);
            this.uploadFiles(setdir, "packages/js/" + name + "/" + version + subdir, ret, names, "text/javascript");
        }
        return ret;
    }

    private void uploadFiles(File dir, String toExplicitPath, List<ContentObject> cos, String[] files, String ct) throws TimeoutException, ClientProtocolException, IOException {
        for (String s : files) {
            String path = null;
            if (toExplicitPath != null) {
                path = toExplicitPath + "/" + s + ".js";
            }
            logger.info("uploading file " + s + " to content store");
            this.uploadFile(cos, path, new File(dir, s + ".js"), ct);
        }
    }

    private void uploadFile(List<ContentObject> cos, String toExplicitPath, File file, String ct) throws TimeoutException, ClientProtocolException, IOException {
        LatchedContentProvider cp = new LatchedContentProvider();
        if (toExplicitPath == null) {
            this.contentstore.newObject(this.cx, new Object[]{file.getName(), ct, cp});
        } else {
            this.contentstore.objectPath(this.cx, new Object[]{toExplicitPath, ct, cp});
        }
        cp.waitFor(15000L, TimeUnit.MILLISECONDS);
        cos.add(cp.co);
        if (cp.co == null) {
            throw new CantHappenException("there was no CO returned");
        }
        String sendTo = cp.co.writeUrl();
        HttpPut put = new HttpPut(sendTo);
        put.setEntity((HttpEntity)new FileEntity(file));
        HttpAnswer resp = this.execute((HttpUriRequest)put);
        if (resp != null) {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            resp.writeTo(s);
            if (s.size() > 0) {
                System.out.println(new String(s.toByteArray()));
            }
        }
    }

    public void storeWebZip(List<ContentObject> cos, File wz) throws TimeoutException {
        LatchedContentProvider cp = new LatchedContentProvider();
        this.contentstore.newObject(this.cx, new Object[]{wz.getName(), "text/plain", cp});
        logger.info("creating new webzip file " + wz);
        cp.waitFor(15000L, TimeUnit.MILLISECONDS);
        cos.add(cp.co);
        if (cp.co == null) {
            throw new CantHappenException("there was no CO returned");
        }
        String sendTo = cp.co.writeUrl();
        if (sendTo == null) {
            throw new CantHappenException("CO did not have a valid writeTo address " + cp.co);
        }
        logger.info("uploading webzip to " + sendTo);
        HttpPut put = new HttpPut(sendTo);
        try {
            FileEntity is;
            if (wz.isDirectory()) {
                logger.info("assembling zip from directory " + wz);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ZipOutputStream zos = new ZipOutputStream(baos);
                for (File f : FileUtils.findFilesUnderMatching((File)wz, (String)"*")) {
                    File wzf = new File(wz, f.getPath());
                    if (wzf.isDirectory()) continue;
                    logger.info("including " + f.getPath() + " of size " + wzf.length());
                    zos.putNextEntry(new ZipEntry(f.getPath()));
                    FileUtils.copyFileToStream((File)wzf, (OutputStream)zos);
                }
                zos.close();
                is = new ByteArrayEntity(baos.toByteArray());
            } else if (wz.canRead()) {
                is = new FileEntity(wz);
            } else {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ZipOutputStream zos = new ZipOutputStream(os);
                zos.close();
                is = new ByteArrayEntity(os.toByteArray());
            }
            logger.info("streaming " + (HttpEntity)is + " of size " + is.getContentLength());
            put.setEntity((HttpEntity)is);
            HttpAnswer resp = this.execute((HttpUriRequest)put);
            if (resp == null) {
                throw new CantHappenException("null response received");
            }
            resp.assertSuccess();
        }
        catch (IOException e) {
            throw new ZinikiHttpException("Unable to upload " + sendTo);
        }
    }

    private HttpAnswer execute(HttpUriRequest put) throws ClientProtocolException, IOException {
        if (this.cli == null) {
            this.cli = new HttpClientExecutor();
        }
        return this.cli.exec(put);
    }

    public void createPackage(String pkg, String version, List<String> modules, List<String> deps) throws TimeoutException {
        LatchedHandler ih = new LatchedHandler();
        this.uploader.newPackage(this.cx, new Object[]{pkg, version, modules, deps, ih});
        ih.waitFor(15000L, TimeUnit.MILLISECONDS);
    }

    public void uploadWebZips(String pkg, String version, List<ContentObject> cos) throws TimeoutException {
        LatchedHandler ih = new LatchedHandler();
        this.uploader.webzips(this.cx, new Object[]{pkg, version, cos, ih});
        ih.waitFor(15000L, TimeUnit.MILLISECONDS);
    }

    private void upload(String packageName, String version, String kind, List<ContentObject> files) throws TimeoutException {
        for (ContentObject co : files) {
            this.uploadFile(packageName, version, kind, co);
        }
    }

    private void uploadFile(String packageName, String version, String kind, ContentObject co) throws TimeoutException {
        Uploaded fp = new Uploaded();
        logger.info("providing " + packageName + ":" + version);
        this.uploader.provideFile(this.cx, new Object[]{packageName, version, kind, co.key(), fp});
        fp.waitFor(15000L, TimeUnit.MILLISECONDS);
        if (fp.uploadTo == null) {
            throw new CantHappenException("there was no CO returned");
        }
        logger.info("uploading " + packageName + ":" + version);
        String sendTo = fp.uploadTo.writeUrl();
        HttpPut put = new HttpPut(sendTo);
        try {
            put.setEntity((HttpEntity)new StringEntity(co.asString()));
            HttpAnswer resp = this.execute((HttpUriRequest)put);
            if (resp == null) {
                throw new CantHappenException("null response received");
            }
            resp.assertSuccess();
        }
        catch (IOException e) {
            throw new ZinikiHttpException("Unable to upload " + co.key());
        }
    }

    public void deploy(String pkg, String version) throws TimeoutException {
        LatchedHandler ih = new LatchedHandler();
        logger.info("deploying " + pkg + ":" + version);
        this.uploader.deploy(this.cx, new Object[]{pkg, version, ih});
        ih.waitFor(60L, TimeUnit.SECONDS);
    }

    @Override
    public void close() throws Exception {
        if (this.broker != null) {
            this.broker.close();
        }
    }

    public static final class Uploaded
    extends LatchedBase
    implements FileProvider {
        private ContentObject uploadTo;

        public void success(EvalContext cx) {
        }

        public Object uploadTo(FLEvalContext arg0, Object[] arg1) {
            this.uploadTo = (ContentObject)arg1[0];
            this.latch.countDown();
            return null;
        }
    }

    public static final class LatchedContentProvider
    extends LatchedBase
    implements ContentProvider {
        private ContentObject co;

        public void success(EvalContext cx) {
        }

        public Object provide(FLEvalContext arg0, Object[] arg1) {
            this.co = (ContentObject)arg1[0];
            this.latch.countDown();
            return null;
        }
    }

    public static final class LatchedHandler
    extends LatchedBase {
        public void success(EvalContext cx) {
            this.latch.countDown();
        }
    }

    public static abstract class LatchedBase
    implements IdempotentHandler {
        protected final CountDownLatch latch = new CountDownLatch(1);
        protected String error;

        public void failure(EvalContext cx, Object error) {
            logger.info("failure returned to client: " + error);
            this.error = (String)error;
            this.latch.countDown();
        }

        public Object name() {
            return null;
        }

        public void waitFor(long cnt, TimeUnit tu) throws TimeoutException {
            try {
                boolean done = this.latch.await(cnt, tu);
                if (!done) {
                    throw new TimeoutException();
                }
                if (this.error != null) {
                    throw new InvalidUsageException(this.error);
                }
            }
            catch (InterruptedException ex) {
                throw new TimeoutException();
            }
        }
    }
}

