/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.compiler.upload;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.ziniki.compiler.upload.HttpAnswer;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.ZinikiHttpException;

public class HttpClientAnswer
implements HttpAnswer {
    private final CloseableHttpResponse response;

    public HttpClientAnswer(CloseableHttpResponse response) {
        this.response = response;
    }

    @Override
    public void assertSuccess() {
        if (this.response == null) {
            throw new CantHappenException("failed to get any response");
        }
        if (this.response.getStatusLine().getStatusCode() / 100 != 2) {
            throw new ZinikiHttpException("received error code " + this.response.getStatusLine());
        }
    }

    @Override
    public boolean isLoggedIn() {
        if (this.response == null) {
            throw new CantHappenException("failed to get any response");
        }
        int code = this.response.getStatusLine().getStatusCode();
        if (code / 100 == 2) {
            return true;
        }
        if (code == 401) {
            return false;
        }
        throw new ZinikiHttpException("received error code " + this.response.getStatusLine());
    }

    @Override
    public String getLoginUri() {
        Header hdr = this.response.getFirstHeader("Login-URI");
        if (hdr == null) {
            throw new CantHappenException("did not receive a Login URI");
        }
        return hdr.getValue();
    }

    @Override
    public String getDesktopUri() {
        Header hdr = this.response.getFirstHeader("Desktop-URI");
        if (hdr == null) {
            throw new CantHappenException("did not receive a Login URI");
        }
        return hdr.getValue();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (this.response.getEntity() != null) {
            this.response.getEntity().writeTo(out);
        }
    }
}

