/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.uris;

import org.dmfs.optional.Optional;
import org.dmfs.rfc3986.Fragment;
import org.dmfs.rfc3986.Scheme;
import org.dmfs.rfc3986.Uri;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.authorities.OptionalLazyAuthority;
import org.dmfs.rfc3986.fragments.OptionalLazyFragment;
import org.dmfs.rfc3986.paths.LazyPath;
import org.dmfs.rfc3986.queries.OptionalLazyQuery;
import org.dmfs.rfc3986.schemes.OptionalLazyScheme;

public final class LazyUri
implements Uri {
    private final UriEncoded mUriEncoded;
    private final OptionalLazyScheme mOptionalScheme;
    private OptionalLazyAuthority mAuthority;
    private LazyPath mPath;
    private OptionalLazyQuery mQuery;
    private Optional<Fragment> mFragment;

    public LazyUri(UriEncoded uri) {
        this.mUriEncoded = uri;
        this.mOptionalScheme = new OptionalLazyScheme(uri);
    }

    @Override
    public Optional<? extends Scheme> scheme() {
        return this.mOptionalScheme;
    }

    public OptionalLazyAuthority authority() {
        if (this.mAuthority == null) {
            this.mAuthority = new OptionalLazyAuthority(this.mUriEncoded.subSequence(this.mOptionalScheme.parsedLength(), this.mUriEncoded.length()));
        }
        return this.mAuthority;
    }

    @Override
    public LazyPath path() {
        if (this.mPath == null) {
            this.mPath = new LazyPath(this.mUriEncoded.subSequence(this.mOptionalScheme.parsedLength() + this.authority().parsedLength(), this.mUriEncoded.length()));
        }
        return this.mPath;
    }

    public OptionalLazyQuery query() {
        if (this.mQuery == null) {
            this.mQuery = new OptionalLazyQuery(this.mUriEncoded.subSequence(this.mOptionalScheme.parsedLength() + this.authority().parsedLength() + this.path().parsedLength(), this.mUriEncoded.length()));
        }
        return this.mQuery;
    }

    @Override
    public Optional<? extends Fragment> fragment() {
        if (this.mFragment == null) {
            this.mFragment = new OptionalLazyFragment(this.mUriEncoded.subSequence(this.mOptionalScheme.parsedLength() + this.authority().parsedLength() + this.path().parsedLength() + this.query().parsedLength(), this.mUriEncoded.length()));
        }
        return this.mFragment;
    }

    @Override
    public boolean isHierarchical() {
        return !this.mOptionalScheme.isPresent() || this.authority().isPresent() || this.path().isAbsolute();
    }

    @Override
    public boolean isAbsolute() {
        return this.mOptionalScheme.isPresent();
    }
}

