/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.encoding;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.Normalized;

public final class FormPrecoded
implements UriEncoded {
    private final CharSequence mEncoded;
    private CharSequence mUtf8Plain;
    private UriEncoded mNormalized;

    public FormPrecoded(CharSequence encoded) {
        this.mEncoded = encoded;
    }

    @Override
    public UriEncoded normalized() {
        if (this.mNormalized == null) {
            this.mNormalized = new Normalized(this);
        }
        return this.mNormalized;
    }

    @Override
    public CharSequence decoded(String charset) throws UnsupportedEncodingException {
        if ("UTF-8".equalsIgnoreCase(charset)) {
            return this.decoded();
        }
        return this.decoded(this.mEncoded, charset);
    }

    @Override
    public CharSequence decoded() {
        if (this.mUtf8Plain == null) {
            try {
                this.mUtf8Plain = this.decoded(this.mEncoded, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Runtime doesn't support UTF-8");
            }
        }
        return this.mUtf8Plain;
    }

    @Override
    public int length() {
        return this.mEncoded.length();
    }

    @Override
    public char charAt(int i) {
        return this.mEncoded.charAt(i);
    }

    @Override
    public UriEncoded subSequence(int startIndex, int endIndex) {
        return new FormPrecoded(this.mEncoded.subSequence(startIndex, endIndex));
    }

    public int hashCode() {
        return this.normalized().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof UriEncoded && this.normalized().equals(obj);
    }

    @Override
    public String toString() {
        return this.mEncoded.toString();
    }

    private CharSequence decoded(CharSequence encoded, String charSet) throws UnsupportedEncodingException {
        if (encoded.length() == 0) {
            return encoded;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(encoded.length());
        int count = encoded.length();
        int i = 0;
        while (i < count) {
            char c = encoded.charAt(i);
            if (c == '%') {
                if (i + 2 >= count) {
                    throw new IllegalArgumentException("Illegal percent encoding.");
                }
                out.write((this.decodeDigit(encoded.charAt(i + 1)) << 4) + this.decodeDigit(encoded.charAt(i + 2)));
                i += 3;
                continue;
            }
            if (c == '+') {
                out.write(32);
                ++i;
                continue;
            }
            out.write(c);
            ++i;
        }
        return out.toString(charSet);
    }

    private int decodeDigit(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        int r = c - 65 & 0xFFFFFFDF;
        if (r < 0 || r > 5) {
            throw new IllegalArgumentException(String.format("%c is not a valid hex digit", new Object[0]));
        }
        return r + 10;
    }
}

