/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.authorities;

import org.dmfs.optional.Absent;
import org.dmfs.optional.Optional;
import org.dmfs.optional.Present;
import org.dmfs.rfc3986.Authority;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.authorities.OptionalLazyUserInfo;
import org.dmfs.rfc3986.utils.Parsed;
import org.dmfs.rfc3986.validation.CharSets;

public final class EncodedAuthority
implements Authority,
Parsed {
    private final UriEncoded mAuthority;
    private OptionalLazyUserInfo mUserInfo;
    private UriEncoded mHost;
    private Optional<Integer> mPort;
    private int mEnd;

    public EncodedAuthority(UriEncoded authority) {
        this.mAuthority = authority;
        this.mUserInfo = new OptionalLazyUserInfo(this.mAuthority);
    }

    public OptionalLazyUserInfo userInfo() {
        return this.mUserInfo;
    }

    @Override
    public UriEncoded host() {
        if (this.mHost == null) {
            this.mHost = this.parsedHost();
        }
        return this.mHost;
    }

    private UriEncoded parsedHost() {
        UriEncoded authority = this.mAuthority;
        int count = authority.length();
        int start = this.userInfo().isPresent() ? this.userInfo().value().length() + 1 : 0;
        int i = start;
        if (i == count) {
            return authority.subSequence(start, count);
        }
        if (authority.charAt(i) == '[') {
            return this.parsedIpvFuture(authority, i, count);
        }
        while (i < count && CharSets.REG_NAME_CHAR.contains(authority.charAt(i))) {
            ++i;
        }
        if (i < count && !CharSets.HOST_TERMINATOR_CHARS.contains(authority.charAt(i))) {
            throw new IllegalArgumentException(String.format("Authority %s contains illegal char %c at position %d", authority.toString(), Character.valueOf(authority.charAt(i)), i));
        }
        return authority.subSequence(start, i);
    }

    private UriEncoded parsedIpvFuture(UriEncoded authority, int start, int length) {
        int i;
        for (i = start + 1; i < length && authority.charAt(i) != ']'; ++i) {
        }
        if (i == length) {
            throw new IllegalArgumentException(String.format("missing ']' in %s", authority.toString()));
        }
        return authority.subSequence(start, i);
    }

    @Override
    public Optional<Integer> port() {
        if (this.mPort == null) {
            this.mPort = this.parsedPort();
        }
        return this.mPort;
    }

    private Optional<Integer> parsedPort() {
        int i;
        UriEncoded authority = this.mAuthority;
        int count = authority.length();
        int portPos = this.host().length() + this.userInfo().parsedLength();
        if (portPos + 1 >= count || authority.charAt(portPos) != ':') {
            this.mEnd = portPos;
            return Absent.absent();
        }
        int port = 0;
        for (i = portPos + 1; i < count && CharSets.DIGIT.contains(authority.charAt(i)); ++i) {
            port = port * 10 + authority.charAt(i) - 48;
        }
        this.mEnd = i;
        if (i == count) {
            return new Present((Object)port);
        }
        char next = authority.charAt(i);
        if (next != '/' && next != '?' && next != '#') {
            throw new IllegalArgumentException(String.format("Authority %s contains illegal char %c at position %d", this.mAuthority.toString(), Character.valueOf(next), i));
        }
        return new Present((Object)port);
    }

    @Override
    public int parsedLength() {
        this.port();
        return this.mEnd;
    }
}

