/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDashboardsRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, ListDashboardsRequest> {
    private static final SdkField<String> DASHBOARD_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDashboardsRequest.getter(ListDashboardsRequest::dashboardNamePrefix)).setter(ListDashboardsRequest.setter(Builder::dashboardNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardNamePrefix").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDashboardsRequest.getter(ListDashboardsRequest::nextToken)).setter(ListDashboardsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_NAME_PREFIX_FIELD, NEXT_TOKEN_FIELD));
    private final String dashboardNamePrefix;
    private final String nextToken;

    private ListDashboardsRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardNamePrefix = builder.dashboardNamePrefix;
        this.nextToken = builder.nextToken;
    }

    public String dashboardNamePrefix() {
        return this.dashboardNamePrefix;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDashboardsRequest)) {
            return false;
        }
        ListDashboardsRequest other = (ListDashboardsRequest)((Object)obj);
        return Objects.equals(this.dashboardNamePrefix(), other.dashboardNamePrefix()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDashboardsRequest").add("DashboardNamePrefix", (Object)this.dashboardNamePrefix()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.dashboardNamePrefix()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDashboardsRequest, T> g) {
        return obj -> g.apply((ListDashboardsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String dashboardNamePrefix;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDashboardsRequest model) {
            super(model);
            this.dashboardNamePrefix(model.dashboardNamePrefix);
            this.nextToken(model.nextToken);
        }

        public final String getDashboardNamePrefix() {
            return this.dashboardNamePrefix;
        }

        @Override
        public final Builder dashboardNamePrefix(String dashboardNamePrefix) {
            this.dashboardNamePrefix = dashboardNamePrefix;
            return this;
        }

        public final void setDashboardNamePrefix(String dashboardNamePrefix) {
            this.dashboardNamePrefix = dashboardNamePrefix;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDashboardsRequest build() {
            return new ListDashboardsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDashboardsRequest> {
        public Builder dashboardNamePrefix(String var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

