/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.flasckAssembler.sources;

import java.io.IOException;
import org.flasck.jvm.assembly.ApplicationAssembly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.common.UOWHost;
import org.ziniki.flasckAssembler.AssemblerSourceHandler;
import org.ziniki.flasckAssembler.sources.AssemblerSourceProvider;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.WrappedException;

public class TDAStorageAssemblerSourceProvider
implements AssemblerSourceProvider,
RelationHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"assembler");
    private final ZiIdFactory factory;

    public TDAStorageAssemblerSourceProvider(@Param(value="idfactory") ZiIdFactory factory) {
        this.factory = factory;
    }

    @Override
    public void source(UnitOfWork uow, String name, AssemblerSourceHandler h) throws IOException {
        Relation r = uow.relation((RelationHandler)this);
        try {
            ZiId id = this.factory.simple("assembler", ((UOWHost)uow.trait(UOWHost.class)).host, "assembly", name);
            logger.info("attempting to retrieve " + id.toString());
            r.load((Object)h);
            r.logic("deliverAssembly");
            r.get("assembly", id.toString());
            r.makeReady();
        }
        catch (GLSException ex) {
            logger.error("error with GLS", (Throwable)ex);
        }
    }

    public void deliverAssembly(AssemblerSourceHandler h, @Slot(value="assembly") ApplicationAssembly asm) {
        try {
            h.handle(asm);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }
}

