/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.flasckAssembler;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.flasck.jvm.assembly.ApplicationAssembly;
import org.flasck.jvm.assembly.FlasckAssembler;
import org.flasck.jvm.assembly.VisitingPackageInfo;
import org.flasck.jvm.assembly.WaitAMo;
import org.flasck.jvm.ziniki.ContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.common.UOWHost;
import org.ziniki.core.concepts.Domain;
import org.ziniki.deployment.fl.JVMApplicationAssembly;
import org.ziniki.deployment.fl.JVMPackageInfo;
import org.ziniki.flasckAssembler.sources.AssemblerSourceProvider;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.server.tda.writers.BackwardsCompatibleBlockingWriter;
import org.ziniki.servlet.basic.InputStreamResponder;
import org.ziniki.servlet.tda.NeedBaseURI;
import org.ziniki.servlet.tda.NeedFullURLWithQuery;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.servlet.tda.ResponseReadyContinuation;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;

public class ZinikiAssembler
extends FlasckAssembler
implements RequestProcessor,
ProvideHostInfo,
NeedBaseURI,
NeedFullURLWithQuery,
RequestPathParameters,
ResponseReadyContinuation,
VisitingPackageInfo,
RelationHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"main");
    private final TxManager txmanager;
    private final ZiIdFactory factory;
    private final AssemblerSourceProvider provider;
    private final String zinikiUri;
    private final String ziwshUri;
    private String host;
    private String app;
    private Responder responder;
    private String baseUri = "";
    private String domainName;
    private URI fullUrl;

    public ZinikiAssembler(@Param(value="txmanager") TxManager txmanager, @Param(value="idfactory") ZiIdFactory factory, @Param(value="provider") AssemblerSourceProvider provider, @Param(value="zinikiUri") String zinikiUri, @Param(value="ziwshUri") String ziwshUri) {
        super(false);
        this.txmanager = txmanager;
        this.factory = factory;
        this.provider = provider;
        this.zinikiUri = zinikiUri;
        this.ziwshUri = ziwshUri;
    }

    public void provideHost(String name, int port) {
        this.host = name;
    }

    public void baseUri(String uri) {
        this.baseUri = uri;
    }

    public void hasSegment(String segment) {
        throw new NotImplementedException();
    }

    public void stringValue(String name, String value, ParameterSource source) {
        if ("app".equals(name)) {
            this.app = value;
        }
    }

    public void integerValue(String name, int value, ParameterSource source) {
        throw new NotImplementedException();
    }

    public void doubleValue(String name, double value, ParameterSource source) {
        throw new NotImplementedException();
    }

    public void fullURLWithQuery(String s) {
        this.fullUrl = URI.create(s);
    }

    public void process(Responder resp) throws Exception {
        logger.info("Requested assembly " + this.app);
        UnitOfWork uow = this.txmanager.newUnit();
        this.domainName = this.host.replaceFirst("^ziniki.", "");
        uow.trait(UOWHost.class, (Object)new UOWHost(this.domainName));
        this.responder = resp;
        resp.setTimeout(5, TimeUnit.SECONDS);
        Relation r = uow.relation((RelationHandler)this);
        String did = this.factory.unique("ziniki", this.domainName, "domain").toString();
        r.get("domain", did);
        r.logic("checkDomainExists");
        uow.block();
        if (uow.hadError()) {
            this.responder.setStatus(500);
            this.responder.setContentType("text/plain");
            PrintWriter w = new PrintWriter((Writer)new BackwardsCompatibleBlockingWriter(this.responder));
            uow.getError().printStackTrace(w);
            w.flush();
            this.responder.done();
        }
    }

    public void checkDomainExists(UnitOfWork uow, @Slot(value="domain") Domain domain) {
        try {
            if (domain == null) {
                throw new RuntimeException("There is no domain " + this.domainName);
            }
            this.provider.source(uow, this.app, source -> {
                logger.info("app returned source of " + source);
                if (source == null) {
                    logger.info("app not found, sending 404");
                    this.responder.setStatus(404);
                    this.responder.done();
                    return;
                }
                try {
                    if (this.fullUrl != null && this.fullUrl.getPath().startsWith("/app/" + this.app + "/packages/")) {
                        this.returnCOIfValidPackage(source);
                    } else {
                        this.assemble(this.app, source);
                    }
                }
                catch (Exception ex) {
                    logger.error("error rendering", (Throwable)ex);
                }
            });
        }
        catch (Exception ex) {
            logger.error("Failure in " + ((Object)((Object)this)).getClass(), (Throwable)ex);
            this.responder.setStatus(500);
            this.responder.setContentType("text/plain");
            PrintWriter w = new PrintWriter((Writer)new BackwardsCompatibleBlockingWriter(this.responder));
            ex.printStackTrace(w);
            w.flush();
            this.responder.done();
            uow.fatalError((Throwable)ex);
        }
    }

    private void returnCOIfValidPackage(ApplicationAssembly source) {
        String pkg = this.fullUrl.getPath();
        int idx = pkg.indexOf("/", 1);
        int idx2 = -1;
        if (idx != -1) {
            idx2 = pkg.indexOf("/", idx + 1);
        }
        if (idx2 == -1) {
            this.responder.setStatus(404);
            this.responder.done();
            return;
        }
        pkg = pkg.substring(idx2 + 1);
        logger.info("want package " + pkg);
        JVMApplicationAssembly aa = (JVMApplicationAssembly)source;
        List packages = (List)aa.get("packages");
        for (JVMPackageInfo packInfo : packages) {
            if (this.hasPackageIn(packInfo, pkg, "javascript", co -> this.deliverIt("text/javascript", (ContentObject)co))) {
                return;
            }
            if (this.hasPackageIn(packInfo, pkg, "css", co -> this.deliverIt("text/css", (ContentObject)co))) {
                return;
            }
            if (!this.hasPackageIn(packInfo, pkg, "assets", co -> this.sendRedirect(co.url()))) continue;
            return;
        }
        this.responder.setStatus(404);
        this.responder.done();
    }

    private void sendRedirect(String url) throws Exception {
        this.responder.redirectTo(url);
    }

    private void deliverIt(String ty, ContentObject co) throws IOException {
        new InputStreamResponder().sendText(this.responder, (Reader)new InputStreamReader(co.asStream()), ty, -1L);
    }

    private boolean hasPackageIn(JVMPackageInfo packInfo, String pkg, String tag, ConsumerExHandler<ContentObject> usage) {
        if (packInfo.has(tag)) {
            List cos = (List)packInfo.get(tag);
            for (ContentObject j : cos) {
                if (!j.key().equals(pkg)) continue;
                System.out.println("found " + pkg);
                try {
                    usage.accept(j);
                }
                catch (Throwable ex) {
                    logger.error("error wrapping " + j.url(), ex);
                }
                this.responder.done();
                return true;
            }
        }
        return false;
    }

    public WaitAMo begin() {
        this.responder.setContentType("text/html");
        return super.begin();
    }

    public void done() {
        this.responder.done();
    }

    public boolean responseReady() {
        return this.traverser.activate().continueOrDone();
    }

    protected WaitAMo writeHTML(String html) {
        if (html == null) {
            return WaitAMo.CONTINUE;
        }
        try {
            return this.responder.write(html, (ResponseReadyContinuation)this) ? WaitAMo.CONTINUE : WaitAMo.WAIT;
        }
        catch (IOException | NotReadyException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    protected void provideServerAddress(StringBuilder sb) {
        sb.append("const baseUri = '" + this.baseUri + "/app/" + this.app + "'\n");
        sb.append("const zinikiLogin = '" + this.zinikiUri + "/login'\n");
        sb.append("const zinikiServer = '" + this.ziwshUri + "'\n");
        sb.append("env.broker.connectToServer(null);\n");
    }

    protected void handleSecurityModule(StringBuilder buffer) {
        buffer.append("window.appl.securityModule = new ZinikiSecurityModule();\n");
    }

    public void streamError(Throwable err) {
        throw new NotImplementedException();
    }

    public static interface ConsumerExHandler<T> {
        public void accept(T var1) throws Exception;
    }
}

