/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.http.decorators;

import java.io.IOException;
import org.dmfs.httpessentials.HttpMethod;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseHandler;
import org.dmfs.httpessentials.converters.PlainStringHeaderConverter;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.headers.BasicSingletonHeaderType;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.typedentity.EntityConverter;
import org.dmfs.oauth2.client.OAuth2AccessToken;

public final class BearerAuthenticatedRequest<T>
implements HttpRequest<T> {
    private static final BasicSingletonHeaderType<String> AUTHORIZATION_HEADER = new BasicSingletonHeaderType("Authorization", (EntityConverter)new PlainStringHeaderConverter());
    private final OAuth2AccessToken mAccessToken;
    private final HttpRequest<T> mDecorated;

    public BearerAuthenticatedRequest(HttpRequest<T> decorated, OAuth2AccessToken accessToken) {
        this.mDecorated = decorated;
        this.mAccessToken = accessToken;
    }

    public HttpMethod method() {
        return this.mDecorated.method();
    }

    public Headers headers() {
        return this.mDecorated.headers().withHeader(AUTHORIZATION_HEADER.entityFromString("Bearer " + this.getAccessToken().toString()));
    }

    private CharSequence getAccessToken() {
        try {
            return this.mAccessToken.accessToken();
        }
        catch (ProtocolException e) {
            throw new RuntimeException("Can't authenticate request", e);
        }
    }

    public HttpRequestEntity requestEntity() {
        return this.mDecorated.requestEntity();
    }

    public HttpResponseHandler<T> responseHandler(HttpResponse response) throws IOException, ProtocolError, ProtocolException {
        return this.mDecorated.responseHandler(response);
    }
}

