/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.errors;

import java.net.URI;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.json.JSONException;
import org.json.JSONObject;

public final class TokenRequestError
extends ProtocolError {
    private static final long serialVersionUID = 1L;
    private final String mErrorResponse;
    private transient JSONObject mErrorObject;

    public TokenRequestError(JSONObject errorObject) throws JSONException {
        super(errorObject.getString("error"));
        this.mErrorObject = errorObject;
        this.mErrorResponse = errorObject.toString();
    }

    public String error() {
        return this.errorObject().optString("error", "unknown");
    }

    public String description() {
        return this.errorObject().optString("error_description", "");
    }

    public URI uri() {
        return this.errorObject().has("error_uri") ? URI.create(this.errorObject().optString("error_uri")) : null;
    }

    private JSONObject errorObject() {
        if (this.mErrorObject == null) {
            try {
                this.mErrorObject = new JSONObject(this.mErrorResponse);
            }
            catch (JSONException e) {
                throw new RuntimeException(String.format("Can't restore JSONObject from String", this.mErrorResponse), e);
            }
        }
        return this.mErrorObject;
    }
}

