/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NotificationEvent {
    ALL("All"),
    IN_PROGRESS("InProgress"),
    SUCCESS("Success"),
    TIMED_OUT("TimedOut"),
    CANCELLED("Cancelled"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NotificationEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NotificationEvent.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationEvent> knownValues() {
        return Stream.of(NotificationEvent.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

