/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SeveritySummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NonCompliantSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NonCompliantSummary> {
    private static final SdkField<Integer> NON_COMPLIANT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(NonCompliantSummary.getter(NonCompliantSummary::nonCompliantCount)).setter(NonCompliantSummary.setter(Builder::nonCompliantCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantCount").build()}).build();
    private static final SdkField<SeveritySummary> SEVERITY_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(NonCompliantSummary.getter(NonCompliantSummary::severitySummary)).setter(NonCompliantSummary.setter(Builder::severitySummary)).constructor(SeveritySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeveritySummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NON_COMPLIANT_COUNT_FIELD, SEVERITY_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer nonCompliantCount;
    private final SeveritySummary severitySummary;

    private NonCompliantSummary(BuilderImpl builder) {
        this.nonCompliantCount = builder.nonCompliantCount;
        this.severitySummary = builder.severitySummary;
    }

    public Integer nonCompliantCount() {
        return this.nonCompliantCount;
    }

    public SeveritySummary severitySummary() {
        return this.severitySummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.severitySummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NonCompliantSummary)) {
            return false;
        }
        NonCompliantSummary other = (NonCompliantSummary)obj;
        return Objects.equals(this.nonCompliantCount(), other.nonCompliantCount()) && Objects.equals(this.severitySummary(), other.severitySummary());
    }

    public String toString() {
        return ToString.builder((String)"NonCompliantSummary").add("NonCompliantCount", (Object)this.nonCompliantCount()).add("SeveritySummary", (Object)this.severitySummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NonCompliantCount": {
                return Optional.ofNullable(clazz.cast(this.nonCompliantCount()));
            }
            case "SeveritySummary": {
                return Optional.ofNullable(clazz.cast(this.severitySummary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NonCompliantSummary, T> g) {
        return obj -> g.apply((NonCompliantSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer nonCompliantCount;
        private SeveritySummary severitySummary;

        private BuilderImpl() {
        }

        private BuilderImpl(NonCompliantSummary model) {
            this.nonCompliantCount(model.nonCompliantCount);
            this.severitySummary(model.severitySummary);
        }

        public final Integer getNonCompliantCount() {
            return this.nonCompliantCount;
        }

        @Override
        public final Builder nonCompliantCount(Integer nonCompliantCount) {
            this.nonCompliantCount = nonCompliantCount;
            return this;
        }

        public final void setNonCompliantCount(Integer nonCompliantCount) {
            this.nonCompliantCount = nonCompliantCount;
        }

        public final SeveritySummary.Builder getSeveritySummary() {
            return this.severitySummary != null ? this.severitySummary.toBuilder() : null;
        }

        @Override
        public final Builder severitySummary(SeveritySummary severitySummary) {
            this.severitySummary = severitySummary;
            return this;
        }

        public final void setSeveritySummary(SeveritySummary.BuilderImpl severitySummary) {
            this.severitySummary = severitySummary != null ? severitySummary.build() : null;
        }

        public NonCompliantSummary build() {
            return new NonCompliantSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NonCompliantSummary> {
        public Builder nonCompliantCount(Integer var1);

        public Builder severitySummary(SeveritySummary var1);

        default public Builder severitySummary(Consumer<SeveritySummary.Builder> severitySummary) {
            return this.severitySummary((SeveritySummary)((SeveritySummary.Builder)SeveritySummary.builder().applyMutation(severitySummary)).build());
        }
    }
}

