/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziniki.ziwsh;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.common.UOWHost;
import org.ziniki.core.ActualZinikiUOW;
import org.ziniki.core.concepts.Domain;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.intf.ZinikiUOW;
import org.ziniki.openid.fl.ZinikiSecurityToken;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.EntryId;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.Param;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.intf.WebSocketFinder;
import org.ziniki.ziwsh.intf.ZiwshListenerDelegate;

public class BrokerDelegate
implements ZiwshListenerDelegate,
RelationHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"BrokerDelegate");
    private ZiIdFactory factory;
    private String domainName;

    public BrokerDelegate(@Param(value="idfactory") ZiIdFactory factory) {
        this.factory = factory;
        logger.info("Created a new BrokerDelegate");
    }

    public void open(WebSocketFinder finder, EvalContext cx, String host, String token, String secret, WSResponder replyTo) {
        logger.info("opening websocket for " + token);
        replyTo.setDessication(token);
        GLUnitOfWork uow = (GLUnitOfWork)cx;
        try {
            this.domainName = host.replaceFirst("^ziniki.", "").replaceFirst("^wsapi.", "");
            UOWHost uh = new UOWHost(this.domainName);
            logger.info("have uh " + uh + " in rememberToken");
            uow.trait(UOWHost.class, (Object)uh);
            Relation r = uow.relation((RelationHandler)this);
            String did = this.factory.unique("ziniki", this.domainName, "domain").toString();
            r.get("domain", did);
            r.logic("checkDomainExists");
            r.load((Object)finder);
            r.load((Object)replyTo);
            r.load("token", (Object)token);
            r.load("secret", (Object)secret);
            uow.makeReady(r);
        }
        catch (Exception ex) {
            logger.error("Error", (Throwable)ex);
            uow.fatalError((Throwable)ex);
        }
    }

    public void checkDomainExists(UnitOfWork uow, Relation r, @Slot(value="domain") Domain domain, @Slot(value="token") String token) throws GLSException {
        if (domain == null) {
            uow.fatalError((Throwable)new RuntimeException("There is no domain " + this.domainName));
            return;
        }
        ZiId id = this.parseToken(uow, token);
        logger.info("retrieving token " + id);
        r.logic("rememberToken");
        r.get("tok", id.toString());
    }

    private ZiId parseToken(UnitOfWork uow, String token) {
        if (token == null) {
            throw new RuntimeException("no security token provided");
        }
        int first = token.indexOf(".");
        if (first == -1) {
            throw new RuntimeException("invalid token - no domain: " + token);
        }
        String domain = token.substring(first + 1);
        token = token.substring(0, first);
        return this.factory.simple("security", domain, "token", token);
    }

    public void rememberToken(WebSocketFinder finder, UnitOfWork uow, @Slot(value="token") String token, @Slot(value="tok") ZinikiSecurityToken tok, @Slot(value="secret") String secret, WSResponder responder) {
        if (tok == null) {
            logger.error("there was no token " + token);
            responder.close("invalid token");
            return;
        }
        if (!secret.equals(tok.getSecret())) {
            logger.error("secret did not match for token " + token);
            responder.close("invalid secret");
            return;
        }
        logger.info("remembering responder " + responder + " for token " + token);
        finder.remember((EvalContext)uow, token, (EntryId)tok, secret, responder);
    }

    public void handle(WebSocketFinder finder, EvalContext cx, String host, String token, WSResponder responder, String text) {
        try {
            GLUnitOfWork uow = (GLUnitOfWork)cx;
            uow.trait(UOWHost.class, (Object)new UOWHost(this.domainName));
            ZiId id = this.parseToken((UnitOfWork)uow, token);
            Relation r = uow.relation((RelationHandler)this);
            r.load((Object)finder);
            r.load((Object)responder);
            r.load("id", (Object)id.toString());
            r.load("token", (Object)token);
            r.load("message", (Object)text);
            r.logic("dispatchMessage");
            r.get("tok", id.toString());
            uow.makeReady(r);
        }
        catch (Exception ex) {
            logger.error("Error", (Throwable)ex);
        }
    }

    public void dispatchMessage(UnitOfWork uow, WebSocketFinder finder, @Slot(value="id") String id, @Slot(value="token") String token, @Slot(value="tok") ZinikiSecurityToken tok, WSResponder responder, @Slot(value="message") String msg) {
        if (tok == null) {
            throw new RuntimeException("no security token found for " + id);
        }
        logger.info("token " + tok.getToken() + " found with " + tok);
        WebSocketFinder.Entry e = finder.find(token, (EntryId)tok);
        if (e == null) {
            throw new RuntimeException("There is no handler for token " + tok.getToken());
        }
        uow.trait(ZinikiUOW.class, (Object)new ActualZinikiUOW(tok));
        e.dispatch((EvalContext)uow, msg);
    }
}

