/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet.oauth;

import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.servlet.oauth.IdentityProvider;
import org.ziniki.servlet.oauth.OAuthProviders;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.utils.FileUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.SsmAsyncClientBuilder;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.ssm.model.ParameterNotFoundException;

public class SSMOAuthProviders
implements OAuthProviders {
    public static final Logger logger = LoggerFactory.getLogger((String)"awscontentstore");
    private final CloseableHttpClient cli = HttpClientBuilder.create().build();
    private final Map<String, IdentityProvider> providers = new TreeMap<String, IdentityProvider>();
    private final String env;
    private final URI redirectUri;

    public SSMOAuthProviders(@Param(value="environment") String env, @Param(value="zinikiUri") String zinikiUri, @Param(value="redirectUri") String redirectUrl) {
        DefaultCredentialsProvider provider;
        this.env = env;
        this.redirectUri = URI.create(zinikiUri).resolve(redirectUrl);
        String profile = System.getProperty("aws.profile");
        logger.info("creating SSMOAuthProviders with profile " + profile + " and env " + env);
        if (profile != null) {
            Path p = new File(System.getProperty("user.home") + "/.aws/credentials").toPath();
            provider = ProfileCredentialsProvider.builder().profileFile(ProfileFile.builder().content(p).type(ProfileFile.Type.CREDENTIALS).build()).profileName(profile).build();
        } else {
            provider = DefaultCredentialsProvider.create();
        }
        SsmAsyncClient ssmClient = (SsmAsyncClient)((SsmAsyncClientBuilder)SsmAsyncClient.builder().credentialsProvider((AwsCredentialsProvider)provider)).build();
        try {
            try {
                GetParameterRequest gpr = (GetParameterRequest)GetParameterRequest.builder().name("/ziniki/" + env + "/oidc/providers").build();
                CompletableFuture parameter = ssmClient.getParameter(gpr);
                List<String> provs = Arrays.asList(((GetParameterResponse)parameter.get()).parameter().value().split(","));
                ArrayList<ProviderInfo> pis = new ArrayList<ProviderInfo>();
                for (String s : provs) {
                    logger.info("Attempting to configure OIDC for " + s);
                    pis.add(this.providerInfo(ssmClient, s));
                }
                for (ProviderInfo pi : pis) {
                    try {
                        IdentityProvider ip = this.configureProvider(pi);
                        this.providers.put(pi.provider, ip);
                        logger.info("Configured OIDC for " + pi.provider);
                    }
                    catch (ParameterNotFoundException ex) {
                        logger.error("failed to configure provider " + pi.provider, (Throwable)ex);
                    }
                }
            }
            catch (ExecutionException ex) {
                throw ex.getCause();
            }
        }
        catch (ParameterNotFoundException ex) {
            logger.error("No OIDC providers found for " + env);
        }
        catch (SdkClientException ex) {
            logger.error("Failed to read SSM for " + env + " as " + profile, (Throwable)ex);
        }
        catch (Throwable t) {
            throw WrappedException.wrap((Throwable)t);
        }
    }

    private ProviderInfo providerInfo(SsmAsyncClient ssmClient, String provider) throws Exception {
        String pidx = "/ziniki/" + this.env + "/oidc/" + provider;
        GetParameterRequest clid = (GetParameterRequest)GetParameterRequest.builder().name(pidx + "/client-id").withDecryption(Boolean.valueOf(true)).build();
        CompletableFuture r = ssmClient.getParameter(clid);
        GetParameterRequest secret = (GetParameterRequest)GetParameterRequest.builder().name(pidx + "/client-secret").withDecryption(Boolean.valueOf(true)).build();
        CompletableFuture cs = ssmClient.getParameter(secret);
        ProviderInfo pi = new ProviderInfo(provider, r, cs);
        this.readWellKnown(pi);
        return pi;
    }

    private IdentityProvider configureProvider(ProviderInfo pi) throws Exception {
        JSONObject wk = pi.wellknown.get();
        String auth = wk.getString("authorization_endpoint");
        String token = wk.getString("token_endpoint");
        String jwks = wk.getString("jwks_uri");
        IdentityProvider ret = new IdentityProvider(pi.provider, pi.r.get().parameter().value(), pi.cs.get().parameter().value(), auth, token, jwks, pi.keys);
        ret.create(this.redirectUri);
        return ret;
    }

    private void readWellKnown(final ProviderInfo pi) {
        final CompletableFuture ret = new CompletableFuture();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpGet get = new HttpGet("https://" + pi.provider + "/.well-known/openid-configuration");
                    try (CloseableHttpResponse response = SSMOAuthProviders.this.cli.execute((HttpUriRequest)get);){
                        String json = new String(FileUtils.readAllStream((InputStream)response.getEntity().getContent()));
                        JSONObject wk = new JSONObject(json);
                        String jwks = wk.getString("jwks_uri");
                        logger.info("reading keys for " + pi.provider + " from " + jwks);
                        SSMOAuthProviders.this.readKeys(jwks, pi.keys);
                        logger.info("finished reading WK for " + pi.provider);
                        ret.complete(wk);
                    }
                }
                catch (Throwable t) {
                    ret.completeExceptionally(t);
                }
            }
        }).start();
        pi.wellknown = ret;
    }

    private void readKeys(String jwks_uri, List<PublicKey> keys) throws Exception {
        HttpGet get = new HttpGet(jwks_uri);
        try (CloseableHttpResponse response = this.cli.execute((HttpUriRequest)get);){
            String json = new String(FileUtils.readAllStream((InputStream)response.getEntity().getContent()));
            JSONObject ko = new JSONObject(json);
            JSONArray arr = ko.getJSONArray("keys");
            for (int i = 0; i < arr.length(); ++i) {
                keys.add(this.extractPublicKeyFrom(arr.getJSONObject(i)));
            }
        }
    }

    private PublicKey extractPublicKeyFrom(JSONObject object) throws Exception {
        String alg = object.getString("alg");
        Base64.Decoder decoder = Base64.getUrlDecoder();
        switch (alg) {
            case "RS256": {
                byte[] key = decoder.decode(object.getString("n"));
                byte[] exp = decoder.decode(object.getString("e"));
                RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, key), new BigInteger(1, exp));
                KeyFactory factory = KeyFactory.getInstance("RSA");
                PublicKey pub = factory.generatePublic(spec);
                return pub;
            }
            case "ES256": {
                String crv = object.getString("crv");
                byte[] x = decoder.decode(object.getString("x"));
                byte[] y = decoder.decode(object.getString("y"));
                KeyFactory factory = KeyFactory.getInstance("EC", "BC");
                ECNamedCurveParameterSpec pspec = ECNamedCurveTable.getParameterSpec((String)crv);
                ECCurve curve = pspec.getCurve();
                ECPoint point = curve.createPoint(new BigInteger(1, x), new BigInteger(1, y));
                ECPublicKeySpec spec = new ECPublicKeySpec(point, (ECParameterSpec)pspec);
                return factory.generatePublic((KeySpec)spec);
            }
        }
        throw new HaventConsideredThisException("cannot handle algorithm " + alg);
    }

    @Override
    public IdentityProvider get(String provider) {
        provider = provider.replace("https://", "").replace("http://", "").replaceFirst(":.*", "").replaceFirst("/.*", "");
        return this.providers.get(provider);
    }

    public static class ProviderInfo {
        private final String provider;
        private final CompletableFuture<GetParameterResponse> r;
        private final CompletableFuture<GetParameterResponse> cs;
        private CompletableFuture<JSONObject> wellknown;
        protected List<PublicKey> keys = new ArrayList<PublicKey>();

        public ProviderInfo(String provider, CompletableFuture<GetParameterResponse> r, CompletableFuture<GetParameterResponse> cs) {
            this.provider = provider;
            this.r = r;
            this.cs = cs;
        }
    }
}

