/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet.oauth;

import java.net.URI;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.dmfs.oauth2.client.BasicOAuth2AuthorizationProvider;
import org.dmfs.oauth2.client.BasicOAuth2Client;
import org.dmfs.oauth2.client.BasicOAuth2ClientCredentials;
import org.dmfs.oauth2.client.OAuth2AuthorizationProvider;
import org.dmfs.oauth2.client.OAuth2Client;
import org.dmfs.oauth2.client.OAuth2ClientCredentials;
import org.dmfs.rfc5545.Duration;

public class IdentityProvider {
    public String baseName;
    public String clientId;
    public String secret;
    public String authEndpoint;
    public String tokenEndpoint;
    public String jwks_uri;
    public final List<PublicKey> keys = new ArrayList<PublicKey>();
    public OAuth2Client client;

    public IdentityProvider(String baseName, String clientId, String secret, String authEndpoint, String tokenEndpoint, String jwks_uri, List<PublicKey> keys) {
        this.baseName = baseName;
        this.clientId = clientId;
        this.secret = secret;
        this.authEndpoint = authEndpoint;
        this.tokenEndpoint = tokenEndpoint;
        this.jwks_uri = jwks_uri;
        this.keys.addAll(keys);
    }

    public void create(URI redirectUrl) {
        BasicOAuth2AuthorizationProvider provider = new BasicOAuth2AuthorizationProvider(URI.create(this.authEndpoint), URI.create(this.tokenEndpoint), new Duration(1, 0, 3600));
        BasicOAuth2ClientCredentials credentials = new BasicOAuth2ClientCredentials(this.clientId, this.secret);
        this.client = new BasicOAuth2Client((OAuth2AuthorizationProvider)provider, (OAuth2ClientCredentials)credentials, redirectUrl);
    }
}

