/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet.oauth;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.security.Key;
import java.security.PublicKey;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.dmfs.httpessentials.client.HttpRequestExecutor;
import org.dmfs.httpessentials.httpurlconnection.HttpUrlConnectionExecutor;
import org.dmfs.jems.optional.Optional;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2InteractiveGrant;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.grants.AuthorizationCodeGrant;
import org.dmfs.oauth2.client.scope.BasicScope;
import org.dmfs.oauth2.client.tokens.JsonAccessToken;
import org.dmfs.rfc3986.Uri;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.Precoded;
import org.dmfs.rfc3986.uris.LazyUri;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.common.UOWHost;
import org.ziniki.interfaces.RelationProvider;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.servlet.oauth.IdentityProvider;
import org.ziniki.servlet.oauth.NoCurrentOAuthTokenException;
import org.ziniki.servlet.oauth.OAuthFlow;
import org.ziniki.servlet.oauth.OAuthProviders;
import org.ziniki.servlet.oauth.TokenState;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.lowlevel.RetrievedObject;
import org.ziniki.tdastore.lowlevel.TDACreateHandler;
import org.ziniki.tdastore.lowlevel.TDARetrieveHandler;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.WrappedException;

public class DMFSOAuthFlow
implements OAuthFlow {
    private final Logger logger = LoggerFactory.getLogger((String)"OAuthFlow");
    private final OAuthProviders providers;
    private final TDAStorage storage;
    private final ZiIdFactory factory;
    private final TxManager txmanager;
    private final HttpRequestExecutor executor;

    public DMFSOAuthFlow(@Param(value="oauthproviders") OAuthProviders providers, @Param(value="storage") TDAStorage storage, @Param(value="idfactory") ZiIdFactory factory, @Param(value="txmanager") TxManager txmanager, @Param(value="relationProvider") RelationProvider relationProvider) {
        this.providers = providers;
        this.storage = storage;
        this.factory = factory;
        this.txmanager = txmanager;
        this.executor = new HttpUrlConnectionExecutor();
    }

    @Override
    public URI begin(String userid, IdentityProvider provider) {
        GLUnitOfWork uow = (GLUnitOfWork)this.txmanager.currentUOW();
        AuthorizationCodeGrant grant = new AuthorizationCodeGrant(provider.client, (OAuth2Scope)new BasicScope(new String[]{"openid"}));
        OAuth2InteractiveGrant.OAuth2GrantState state = grant.state();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(state);
            oos.close();
            ZiId tokenId = this.factory.simple("oauthtoken", ((UOWHost)uow.trait(UOWHost.class)).host, "token", userid);
            String serstate = Base64.getEncoder().encodeToString(baos.toByteArray());
            TokenState token = new TokenState((FLEvalContext)uow);
            token.setProvider(provider.baseName);
            token.setSerstate(serstate);
            final ArrayList errs = new ArrayList();
            final CountDownLatch cdl = new CountDownLatch(2);
            TDACreateHandler handler = new TDACreateHandler(){

                public void success() {
                    cdl.countDown();
                }

                public void error(Throwable ex) {
                    errs.add(ex);
                    cdl.countDown();
                }

                public void alreadyExists() {
                    errs.add(new RuntimeException("already exists"));
                    cdl.countDown();
                }
            };
            this.storage.create((UnitOfWork)uow, tokenId.toString(), (Object)token, this.storage.expireAfter(1, (TemporalUnit)ChronoUnit.HOURS), handler);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        URI authorizationUrl = grant.authorizationUrl();
        return authorizationUrl;
    }

    @Override
    public String handleRedirect(String userid, URI redirectUrl) throws Exception {
        GLUnitOfWork uow = (GLUnitOfWork)this.txmanager.currentUOW();
        final ZiId tokenId = this.factory.simple("oauthtoken", ((UOWHost)uow.trait(UOWHost.class)).host, "token", userid);
        final CompletableFuture ret = new CompletableFuture();
        UnitOfWork cx = this.txmanager.currentUOW();
        this.storage.retrieve(cx, tokenId.toString(), new TDARetrieveHandler(){

            public void notfound() {
                DMFSOAuthFlow.this.logger.info("did not find " + tokenId);
                ret.complete(null);
            }

            public <T> void found(RetrievedObject<T> retrieved) {
                DMFSOAuthFlow.this.logger.info("found " + tokenId + " completing " + ret);
                ret.complete((TokenState)((Object)retrieved.object()));
            }

            public void error(Throwable ex) {
                DMFSOAuthFlow.this.logger.error("error retrieving association", ex);
                ret.completeExceptionally(ex);
            }
        });
        this.logger.info("Blocking on " + ret + " to allow storage to be async but oauth not");
        TokenState ts = (TokenState)((Object)ret.get(5L, TimeUnit.SECONDS));
        if (ts == null) {
            throw new NoCurrentOAuthTokenException(tokenId);
        }
        IdentityProvider provider = this.providers.get(ts.getProvider());
        if (provider == null) {
            throw new CantHappenException("don't have provider " + ts.getProvider());
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(ts.getSerstate())));
            OAuth2InteractiveGrant.OAuth2GrantState state = (OAuth2InteractiveGrant.OAuth2GrantState)ois.readObject();
            OAuth2InteractiveGrant grant = state.grant(provider.client);
            OAuth2AccessToken token = grant.withRedirect((Uri)new LazyUri((UriEncoded)new Precoded((CharSequence)redirectUrl.toString()))).accessToken(this.executor);
            JsonAccessToken json = (JsonAccessToken)token;
            Optional idt = json.extraParameter("id_token");
            if (idt.isPresent()) {
                String idv = (String)idt.value();
                System.out.println("id_token = " + idv);
                JwtParser p = Jwts.parser();
                for (PublicKey k : provider.keys) {
                    try {
                        p.setSigningKey((Key)k);
                        Jwt parsedToken = p.parse(idv);
                        Claims c = (Claims)parsedToken.getBody();
                        String loginid = c.getIssuer() + "/" + c.getSubject();
                        this.logger.info("have issuer " + c.getIssuer() + " and subject " + c.getSubject() + "; loginId = " + loginid);
                        System.out.println(loginid);
                        return loginid;
                    }
                    catch (SignatureException | UnsupportedJwtException ex) {
                        System.out.println("key did not work ... trying next");
                    }
                }
                throw new CantHappenException("none of the keys worked");
            }
            throw new CantHappenException("no id_token present");
        }
        catch (Throwable t) {
            throw WrappedException.wrap((Throwable)t);
        }
    }
}

