/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3TemplateLoader
implements TemplateLoader {
    private static final Logger logger = LoggerFactory.getLogger((String)"FreeMarker");
    private final S3Client s3;
    private final String bucketName;
    private final String root;
    private final Map<S3Object, InputStreamReader> readers = new HashMap<S3Object, InputStreamReader>();

    public S3TemplateLoader(String s3path) {
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.create();
        this.s3 = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).region(Region.US_EAST_1)).build();
        URI uri = URI.create(s3path);
        if (!"s3".equals(uri.getScheme())) {
            throw new NotImplementedException("Scheme must be s3");
        }
        this.bucketName = uri.getHost();
        this.root = uri.getPath().replaceFirst("^/*", "").replaceFirst("/*$", "/");
    }

    public Object findTemplateSource(String key) throws IOException {
        try {
            logger.info("Attempting to find template with key " + key + " in bucket " + this.bucketName);
            ListObjectsRequest lor = (ListObjectsRequest)ListObjectsRequest.builder().bucket(this.bucketName).prefix(this.root + key).build();
            logger.info("request is " + lor);
            List listObjects = this.s3.listObjects(lor).contents();
            if (listObjects.isEmpty()) {
                return null;
            }
            S3Object ret = (S3Object)listObjects.get(0);
            logger.info("Found template " + ret);
            return ret;
        }
        catch (NoSuchKeyException ex) {
            return null;
        }
        catch (S3Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public long getLastModified(Object arg0) {
        S3Object obj = (S3Object)arg0;
        return obj.lastModified().toEpochMilli();
    }

    public Reader getReader(Object arg0, String encoding) throws IOException {
        S3Object obj = (S3Object)arg0;
        GetObjectRequest gor = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(obj.key()).build();
        InputStreamReader reader = new InputStreamReader((InputStream)this.s3.getObject(gor, ResponseTransformer.toInputStream()), encoding);
        this.readers.put(obj, reader);
        return reader;
    }

    public void closeTemplateSource(Object arg0) throws IOException {
        S3Object obj = (S3Object)arg0;
        InputStreamReader r = this.readers.remove(obj);
        if (r != null) {
            r.close();
        }
    }
}

