/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.utils.FileUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.S3Exception;

public class S3Reader {
    private final S3Client s3;

    S3Reader() {
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.create();
        this.s3 = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).region(Region.US_EAST_1)).build();
    }

    public String read(String s3path) throws NoSuchKeyException, S3Exception, AwsServiceException, SdkClientException, UnsupportedEncodingException {
        URI uri = URI.create(s3path);
        if (!"s3".equals(uri.getScheme())) {
            throw new NotImplementedException("Scheme must be s3");
        }
        String bucketName = uri.getHost();
        String key = uri.getPath().replaceFirst("^/*", "");
        GetObjectRequest gor = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(key).build();
        InputStreamReader reader = new InputStreamReader((InputStream)this.s3.getObject(gor, ResponseTransformer.toInputStream()), "UTF-8");
        return FileUtils.readAllReaderAsString((Reader)reader);
    }
}

