/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import java.io.IOException;
import java.net.URI;
import org.openid4java.consumer.ConsumerManager;
import org.ziniki.core.ZinikiCore;
import org.ziniki.interfaces.SecurityStore;
import org.ziniki.interfaces.TemplateEngine;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.servlet.Security;
import org.ziniki.servlet.oauth.NoCurrentOAuthTokenException;
import org.ziniki.servlet.oauth.OAuthFlow;
import org.ziniki.servlet.tda.NeedFullURLWithQuery;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.GoingToBlock;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.utils.IRandom;

public class OAuthCallbackAction
extends Security
implements RequestProcessor,
NeedFullURLWithQuery {
    private final OAuthFlow flow;
    private final String loginCompleteUrl;
    private final String loginAgainUrl;
    private String fullUrl;

    public OAuthCallbackAction(@Param(value="zinikiUri") String zinikiUri, @Param(value="random") IRandom random, @Param(value="consumerManager") ConsumerManager consumer, @Param(value="txmanager") TxManager txmanager, @Param(value="storage") TDAStorage storage, @Param(value="core") ZinikiCore core, @Param(value="securityStore") SecurityStore securityStore, @Param(value="templateEngine") TemplateEngine te, @Param(value="idfactory") ZiIdFactory factory, @Param(value="oauthflow") OAuthFlow flow) {
        super(random, consumer, txmanager, core, securityStore, te, factory);
        this.loginCompleteUrl = zinikiUri + "/loginComplete";
        this.loginAgainUrl = zinikiUri + "/login";
        this.flow = flow;
    }

    public void fullURLWithQuery(String s) {
        this.fullUrl = s;
    }

    public void process(Responder resp) throws IOException {
        super.before(resp);
        try {
            if (this.isGet()) {
                this.r.logic("handleCallback");
            } else {
                this.r.logic("send405");
            }
            super.after(resp);
        }
        catch (Exception e) {
            super.handleException(resp, e);
        }
    }

    @GoingToBlock
    public void handleCallback(Responder resp) throws Exception, IOException {
        security.set(this);
        try {
            String cred = this.flow.handleRedirect(this.userid, URI.create(this.fullUrl));
            this.securityStore.bindSessionToCredential(this.uow, this.userid, cred);
            resp.redirectTo(this.loginCompleteUrl);
        }
        catch (NoCurrentOAuthTokenException e) {
            resp.clearCookie("userid");
            resp.redirectTo(this.loginAgainUrl);
        }
    }
}

