/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashMap;
import org.flasck.jvm.FLEvalContext;
import org.openid4java.consumer.ConsumerManager;
import org.ziniki.core.ZinikiCore;
import org.ziniki.core.concepts.Credential;
import org.ziniki.core.concepts.Identity;
import org.ziniki.core.concepts.IdentityAndPersona;
import org.ziniki.interfaces.CredState;
import org.ziniki.interfaces.SecurityStore;
import org.ziniki.interfaces.TemplateEngine;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.servlet.Security;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.utils.IRandom;

public class NewUserProfile
extends Security {
    private String pname;
    private final String loginCompleteUrl;

    public NewUserProfile(@Param(value="zinikiUri") String zinikiUri, @Param(value="random") IRandom random, @Param(value="consumerManager") ConsumerManager consumer, @Param(value="txmanager") TxManager txmgr, @Param(value="storage") TDAStorage storage, @Param(value="core") ZinikiCore core, @Param(value="securityStore") SecurityStore securityStore, @Param(value="templateEngine") TemplateEngine te, @Param(value="idfactory") ZiIdFactory factory) {
        super(random, consumer, txmgr, core, securityStore, te, factory);
        this.loginCompleteUrl = zinikiUri + "/loginComplete";
    }

    @Override
    public void stringValue(String name, String value, ParameterSource source) {
        if (name.equals("profilename")) {
            this.pname = value;
        }
    }

    public void process(Responder resp) throws IOException {
        super.before(resp);
        try {
            if (this.isGet()) {
                this.r.logic("offerProfileRegistrationForm");
            } else if (this.isPost()) {
                this.r.logic("registerNewUser");
            } else {
                this.r.logic("send405");
            }
            super.after(resp);
        }
        catch (Exception ex) {
            super.handleException(resp, ex);
        }
    }

    public void offerProfileRegistrationForm(Responder resp) throws IOException, TemplateException {
        this.te.sendResource(resp, "userProfile.fm", new HashMap());
    }

    public void registerNewUser() throws IOException, NotReadyException, GLSException {
        this.securityStore.getTokenState(this.r, "state", this.userid);
        this.r.logic("handleTokenState");
    }

    public void handleTokenState(Responder resp, @Slot(value="state") CredState cs) throws IOException, NotReadyException, GLSException {
        if (cs != CredState.REGISTERING) {
            this.logger.info("cookie " + this.userid + " was not in registering state");
            resp.setStatus(409);
            resp.write("Cannot register a user who is already registered\n", null);
            return;
        }
        this.securityStore.getCredentialFor(this.r, "desiredCred", this.userid);
        this.r.logic("doRegistration");
    }

    public void doRegistration(UnitOfWork uow, @Slot(value="desiredCred") String desiredCred) throws GLSException {
        this.logger.info("creating new credential for " + this.userid);
        Credential cred = this.core.newCredential(uow, this.r, "cred", desiredCred);
        IdentityAndPersona ip = this.core.newIdentity(uow, this.r, "identity", "persona");
        Identity id = ip.identity();
        this.logger.info("have credential " + cred);
        this.logger.info("Have new identity " + id);
        cred.setIdentity(id);
        id.addCredential((FLEvalContext)uow, cred);
        this.core.saveCredential(this.r, cred);
        this.securityStore.bindSessionToIdentity(uow, this.userid, id);
        ip.persona().setField("profilename", this.pname);
        this.r.load("url", (Object)this.loginCompleteUrl);
        this.redirectTo(this.loginCompleteUrl);
    }
}

