/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.openid4java.consumer.ConsumerManager;
import org.ziniki.core.ZinikiCore;
import org.ziniki.interfaces.CredState;
import org.ziniki.interfaces.SecurityStore;
import org.ziniki.interfaces.TemplateEngine;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.servlet.Security;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.utils.IRandom;

public class LoginCompleteAction
extends Security {
    private final String registerUrl;
    private String desktopUri;
    private String zinikiUri;

    public LoginCompleteAction(@Param(value="zinikiUri") String zinikiUrl, @Param(value="random") IRandom random, @Param(value="consumerManager") ConsumerManager consumer, @Param(value="txmanager") TxManager txmgr, @Param(value="storage") TDAStorage storage, @Param(value="core") ZinikiCore core, @Param(value="securityStore") SecurityStore securityStore, @Param(value="templateEngine") TemplateEngine te, @Param(value="idfactory") ZiIdFactory factory) {
        super(random, consumer, txmgr, core, securityStore, te, factory);
        this.zinikiUri = zinikiUrl;
        this.registerUrl = zinikiUrl + "/register";
    }

    @Override
    public String[] cookiesWanted() {
        return new String[]{"userid", "desktopUri"};
    }

    @Override
    public void cookie(String name, String value) {
        if (name.equals("desktopUri")) {
            this.desktopUri = value;
            this.logger.info("cookie 'desktopUri' found for LoginComplete with value " + this.desktopUri);
        } else {
            super.cookie(name, value);
        }
    }

    public void process(Responder resp) throws IOException {
        super.before(resp);
        try {
            if (this.isGet()) {
                this.r.logic("createSessionWithUserRecordOrIndicateNotRegistered");
            } else {
                this.r.logic("send405");
            }
            super.after(resp);
        }
        catch (Exception ex) {
            super.handleException(resp, ex);
        }
    }

    public void createSessionWithUserRecordOrIndicateNotRegistered(Responder resp) throws GLSException {
        this.securityStore.getTokenSecret(this.r, "secret", this.userid);
        this.securityStore.getTokenState(this.r, "state", this.userid);
        this.r.logic("handleTokenState");
    }

    public void handleTokenState(Responder resp, @Slot(value="secret") String secret, @Slot(value="state") CredState state) throws IOException, TemplateException {
        this.logger.info("cred for " + this.userid + " is in state " + state);
        if (secret == null || state == null) {
            this.notAuthorized(resp, this.zinikiUri);
        } else if (state == CredState.REGISTERING) {
            this.logger.info("Forwarding on to REGISTER");
            this.redirectTo(this.registerUrl);
        } else if (this.desktopUri != null) {
            String toDesktop = URLDecoder.decode(this.desktopUri, Charset.forName("UTF-8")) + "?token=" + this.userid + "&secret=" + secret;
            this.logger.info("Redirecting to " + toDesktop + " to provide the token");
            this.redirectTo(toDesktop);
        } else {
            this.logger.info("Sending back cookie " + this.userid + " as the Ziniki Token header with secret " + secret);
            resp.setHeader("X-Ziniki-Token", this.userid);
            resp.setHeader("X-Ziniki-Secret", secret);
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("userid", this.userid);
            model.put("secret", secret);
            this.te.sendResource(resp, "loginCompleted.fm", model);
        }
    }
}

