/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.interfaces.TemplateEngine;
import org.ziniki.server.tda.RequestMethod;
import org.ziniki.server.tda.writers.BackwardsCompatibleBlockingWriter;
import org.ziniki.servlet.tda.CookieAware;
import org.ziniki.servlet.tda.ProvideHeaders;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.ziwsh.intf.Param;

public class Index
implements RequestProcessor,
RequestMethod,
CookieAware,
ProvideHeaders {
    protected final Logger logger = LoggerFactory.getLogger((String)"Index");
    private TemplateEngine te;
    private boolean isGet;
    private String token;
    private String host;

    public Index(@Param(value="templateEngine") TemplateEngine te) {
        this.te = te;
    }

    public String[] cookiesWanted() {
        return new String[]{"token"};
    }

    public void cookie(String name, String value) {
        if (name.equals("token")) {
            this.token = value;
        }
    }

    public void requestMethod(String methodName) {
        this.isGet = methodName.equals("GET");
    }

    public void header(String name, String value) {
        if (name.equalsIgnoreCase("X-Ziniki-Host")) {
            this.host = value;
        }
    }

    public void process(Responder r) throws Exception {
        try {
            if (this.isGet) {
                this.logger.info("Index Servlet handling request with token " + this.token);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("token", this.token);
                map.put("remote", this.host);
                this.te.sendResource(r, "index.fm", map);
            } else {
                r.setStatus(405);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            r.setStatus(500);
            r.setContentType("text/plain");
            ex.printStackTrace(new PrintWriter((Writer)new BackwardsCompatibleBlockingWriter(r)));
        }
    }
}

