/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;

public class FormRedirect {
    private final String url;
    private final List<NameValuePair> args;

    private FormRedirect(String action, List<NameValuePair> args) {
        this.url = action;
        this.args = args;
    }

    public static FormRedirect parse(String html) {
        String action = FormRedirect.extractAction(html);
        System.out.println(action);
        Matcher fm = FormRedirect.extractFields(html);
        ArrayList<NameValuePair> args = new ArrayList<NameValuePair>();
        while (fm.find()) {
            args.add((NameValuePair)new BasicNameValuePair(fm.group(1), fm.group(2)));
        }
        if (args.isEmpty()) {
            throw new RuntimeException("Could not find any form fields in html");
        }
        return new FormRedirect(action, args);
    }

    private static String extractAction(String html) {
        Pattern p = Pattern.compile("action=\"([^\"]*)\"");
        Matcher m = p.matcher(html);
        if (!m.find()) {
            throw new RuntimeException("Could not find form 'action' in html");
        }
        return m.group(1);
    }

    private static Matcher extractFields(String html) {
        Pattern p = Pattern.compile("name=\"(openid.[^\"]*)\" value=\"([^\"]*)\"");
        return p.matcher(html);
    }

    public void assertURL(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.url);
    }

    public void assertFieldCount(int cnt) {
        Assert.assertEquals((long)cnt, (long)this.args.size());
    }

    public void assertField(String name, String expected) {
        for (NameValuePair x : this.args) {
            if (!x.getName().equals(name)) continue;
            Assert.assertEquals((String)("incorrect value for " + name), (Object)expected, (Object)x.getValue());
            return;
        }
        Assert.fail((String)("there is no field " + name));
    }
}

