/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.PendingDomain;
import org.ziniki.common.UOWHost;
import org.ziniki.interfaces.TemplateEngine;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.server.tda.RequestMethod;
import org.ziniki.servlet.S3Reader;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.RequestQueryAndPostParameters;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.utils.FileUtils;

public class CreateDomain
implements RequestProcessor,
ProvideHostInfo,
RequestMethod,
RequestQueryAndPostParameters,
RelationHandler {
    private static int UOW_TIMEOUT;
    protected final Logger logger = LoggerFactory.getLogger((String)"Security");
    private static int size;
    private static SecureRandom random;
    private static Base64.Encoder b64;
    private static Base64.Decoder deb64;
    private S3Reader s3reader;
    private final TxManager txmanager;
    private final ZiIdFactory factory;
    private final byte[] key;
    private final TemplateEngine te;
    private String zinikiDomain;
    private int port;
    private String method;
    private String user;

    public CreateDomain(@Param(value="txmanager") TxManager txmanager, @Param(value="idfactory") ZiIdFactory factory, @Param(value="prefixPort") int prefixPort, @Param(value="publicKey") String publicKeyFile, @Param(value="templateEngine") TemplateEngine te) throws Exception {
        this.txmanager = txmanager;
        this.factory = factory;
        this.te = te;
        this.key = this.readKey(publicKeyFile);
    }

    public void provideHost(String name, int port) {
        this.zinikiDomain = name;
        this.port = port;
    }

    public void requestMethod(String methodName) {
        this.method = methodName;
    }

    public void stringValue(String name, String value, ParameterSource source) {
        if ("userid".equals(name)) {
            this.user = value;
        }
    }

    public void process(Responder resp) throws Exception {
        switch (this.method) {
            case "GET": {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("isZiniki", this.zinikiDomain.startsWith("ziniki."));
                props.put("domain", this.zinikiDomain.replaceFirst("^ziniki.", ""));
                this.te.sendResource(resp, "domainForm.fm", props);
                break;
            }
            case "POST": {
                this.initializeDomain(resp);
                break;
            }
            default: {
                resp.setStatus(405);
            }
        }
    }

    public void initializeDomain(Responder resp) throws Exception {
        if (this.zinikiDomain == null || !this.zinikiDomain.startsWith("ziniki.")) {
            resp.setStatus(400);
            resp.write("cannot create a domain if the server host does not start ziniki.", null);
        } else if (this.user == null || !this.user.startsWith("https://")) {
            resp.setStatus(400);
            resp.write("cannot create a domain without a valid user URI", null);
        } else {
            UnitOfWork uow = this.txmanager.newUnit();
            String domain = this.zinikiDomain.replaceFirst("^ziniki.", "");
            uow.trait(UOWHost.class, (Object)new UOWHost(domain));
            resp.setTimeout(uow + " createDomain", UOW_TIMEOUT, TimeUnit.MILLISECONDS);
            Relation r = uow.relation((RelationHandler)this);
            r.load((Object)resp);
            byte[] msg = this.generateMessage();
            String token = new String(msg, "UTF-8");
            this.logger.info("Created message for domain " + domain + ": " + token);
            String domainId = this.factory.nextInSequence("pending", domain, "domain").toString();
            int idx = domainId.lastIndexOf("/");
            String path = domainId.substring(idx + 1);
            PendingDomain tmpDomain = (PendingDomain)PendingDomain.eval((FLEvalContext)((FLEvalContext)uow), (Object[])new Object[]{domain, this.user, token});
            r.create(domainId, (Object)tmpDomain);
            uow.enact();
            byte[] result = CreateDomain.encrypt(this.key, msg);
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("pending", path);
            props.put("domain", domain);
            props.put("token", b64.encodeToString(result));
            if (this.port == -1 || this.port == 443) {
                props.put("port", "");
            } else {
                props.put("port", ":" + this.port);
            }
            uow.waitForResult();
            this.te.sendResource(resp, "createDomain.fm", props);
        }
        resp.done();
    }

    private byte[] generateMessage() {
        byte[] buf = new byte[size / 8 - 11];
        for (int i = 0; i < buf.length; ++i) {
            int k = random.nextInt(62) + 48;
            if (k >= 58) {
                k += 6;
            }
            if (k >= 91) {
                k += 6;
            }
            buf[i] = (byte)k;
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readKey(String publicKeyFile) throws Exception {
        String data;
        if (publicKeyFile.startsWith("s3:")) {
            if (this.s3reader == null) {
                CreateDomain createDomain = this;
                synchronized (createDomain) {
                    if (this.s3reader == null) {
                        this.s3reader = new S3Reader();
                    }
                }
            }
            data = this.s3reader.read(publicKeyFile);
        } else {
            data = FileUtils.readFile((File)new File(publicKeyFile));
        }
        return deb64.decode(data);
    }

    private static byte[] encrypt(byte[] publicKey, byte[] msg) throws InvalidCipherTextException, IOException {
        AsymmetricKeyParameter akp = PublicKeyFactory.createKey((byte[])publicKey);
        RSAEngine e = new RSAEngine();
        e = new PKCS1Encoding((AsymmetricBlockCipher)e);
        e.init(true, (CipherParameters)akp);
        return e.processBlock(msg, 0, msg.length);
    }

    static {
        String tostr = System.getenv("ZINIKI_UOW_TIMEOUT");
        if (tostr == null) {
            tostr = System.getProperty("ziniki.uow.timeout");
        }
        UOW_TIMEOUT = tostr != null ? Integer.parseInt(tostr) : 5000;
        size = 1024;
        random = new SecureRandom();
        b64 = Base64.getEncoder();
        deb64 = Base64.getDecoder();
    }
}

