/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.TypeOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.DataStore;
import org.ziniki.PendingDomain;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.common.UOWHost;
import org.ziniki.core.ZinikiCore;
import org.ziniki.core.concepts.Credential;
import org.ziniki.core.concepts.Domain;
import org.ziniki.core.concepts.Identity;
import org.ziniki.core.concepts.IdentityAndPersona;
import org.ziniki.core.concepts.Persona;
import org.ziniki.core.fl.IdentityAndPersonaPair;
import org.ziniki.core.fl.JVMArena;
import org.ziniki.core.fl.JVMDomain;
import org.ziniki.coreimpl.FailUOWHandler;
import org.ziniki.interfaces.TemplateEngine;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.secondaries.PackageByName;
import org.ziniki.secondaries.PackageByNameVersion;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.server.tda.RequestMethod;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.RequestQueryAndPostParameters;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.utils.FileUtils;
import org.zinutils.utils.StringUtil;

public class CompleteDomain
implements RequestProcessor,
ProvideHostInfo,
RequestMethod,
RequestQueryAndPostParameters,
RelationHandler {
    private static int UOW_TIMEOUT;
    protected final Logger logger = LoggerFactory.getLogger((String)"Security");
    private final TxManager txmanager;
    private final ZiIdFactory factory;
    private final DataStore ds;
    private final ZinikiCore core;
    private final int port;
    private final TemplateEngine te;
    private String zinikiDomain;
    private String method;
    private String pendingid;
    boolean success = false;
    private String domain;
    private String userid;

    public CompleteDomain(@Param(value="txmanager") TxManager txmanager, @Param(value="idfactory") ZiIdFactory factory, @Param(value="core") ZinikiCore core, @Param(value="datastore") DataStore ds, @Param(value="prefixPort") int port, @Param(value="templateEngine") TemplateEngine te) {
        this.txmanager = txmanager;
        this.factory = factory;
        this.core = core;
        this.ds = ds;
        this.port = port;
        this.te = te;
    }

    public TxManager getTxManager() {
        return this.txmanager;
    }

    public ZiIdFactory getFactory() {
        return this.factory;
    }

    public void provideHost(String name, int port) {
        this.zinikiDomain = name;
    }

    public void requestMethod(String methodName) {
        this.method = methodName;
    }

    public void stringValue(String name, String value, ParameterSource source) {
        if ("pending".equals(name)) {
            this.pendingid = value;
        }
    }

    public void process(Responder resp) throws Exception {
        switch (this.method) {
            case "GET": {
                this.completeDomain(resp);
                break;
            }
            default: {
                resp.setStatus(405);
            }
        }
    }

    public void completeDomain(Responder resp) throws Exception {
        this.logger.info("attempting to complete domain " + this.zinikiDomain);
        if (this.zinikiDomain == null || !this.zinikiDomain.startsWith("ziniki.")) {
            resp.setStatus(400);
            resp.write("cannot create a domain if the server host does not start ziniki.", null);
        } else if (this.pendingid == null) {
            resp.setStatus(400);
            resp.write("must specify a value for the pending creation", null);
        } else {
            UnitOfWork uow = this.txmanager.newUnit();
            this.domain = this.zinikiDomain.replaceFirst("^ziniki.", "");
            uow.trait(UOWHost.class, (Object)new UOWHost(this.domain));
            resp.setTimeout(uow + " completeDomain", UOW_TIMEOUT, TimeUnit.MILLISECONDS);
            Relation r = uow.relation((RelationHandler)this);
            r.load("domain", (Object)this.domain);
            r.load((Object)resp);
            String pid = this.factory.simple("pending", this.domain, "domain", this.pendingid).toString();
            r.get("pending", pid);
            r.logic("findCredForPendingDomain");
            r.logic("findIdentityAndPersonaForExistingCreds");
            r.logic("createDomain");
            r.background("wktoken");
            uow.enact();
            String wktoken = null;
            try {
                CloseableHttpClient cli = HttpClients.createDefault();
                Object pt = "";
                if (this.port != -1) {
                    pt = ":" + this.port;
                }
                String getUrl = "https://" + this.domain + (String)pt + "/.well-known/ziniki-key";
                this.logger.info("Attempting to GET " + getUrl);
                HttpGet get = new HttpGet(getUrl);
                HttpResponse cliresp = cli.execute((HttpUriRequest)get);
                if (cliresp != null && cliresp.getEntity() != null) {
                    wktoken = new String(FileUtils.readAllStream((InputStream)cliresp.getEntity().getContent()), "UTF-8");
                }
                this.logger.info("Have token " + wktoken);
            }
            catch (Exception ex) {
                this.logger.error("failed to retrieve token from " + this.domain, (Throwable)ex);
            }
            r.load("wktoken", wktoken);
            r.whenCommitted("sendReply");
            r.whenRolledBack("sendReply");
            uow.waitForResult();
        }
    }

    public void findCredForPendingDomain(UnitOfWork uow, Relation r, @Slot(value="pending") PendingDomain pd) throws Exception {
        if (this.domain != null && pd != null) {
            this.userid = (String)pd._field_userid((FLEvalContext)uow, null);
            String credid = this.factory.simple("security", "cross.domain", "credential", URLEncoder.encode(this.userid, "UTF-8")).toString();
            r.get("cred", credid);
        } else {
            r.load("cred", null);
        }
    }

    public void findIdentityAndPersonaForExistingCreds(Relation r, @Slot(value="cred") Credential cred) throws GLSException {
        if (cred == null) {
            r.load("identity", null);
            r.load("persona", null);
        } else {
            r.get("identity", cred.identity().toString());
            r.logic("getPersonaFromIdentity");
        }
    }

    public void getPersonaFromIdentity(Relation r, @Slot(value="identity") Identity identity) {
        if (identity == null) {
            r.load("persona", null);
        } else {
            r.get("persona", identity.getRootPersona().toString());
        }
    }

    public void createDomain(UnitOfWork uow, Relation r, @Slot(value="pending") PendingDomain pd, @Slot(value="wktoken") String wktoken, @Slot(value="identity") Identity identity, @Slot(value="persona") Persona persona) throws IOException, TemplateException {
        if (this.domain != null && pd != null && wktoken != null) {
            wktoken = StringUtil.removeAllWS((String)wktoken);
            this.logger.info("after stripping, token is " + wktoken.length() + " => *" + wktoken + "*");
            FLEvalContext cx = (FLEvalContext)uow;
            Object mytoken = pd._field_token(cx, null);
            Object reqdomain = pd._field_domain(cx, null);
            if (wktoken.equals(mytoken) && this.domain.equals(reqdomain)) {
                this.success = true;
                this.userid = (String)pd._field_userid(cx, null);
                IdentityAndPersonaPair ip = identity == null ? this.createUserThings(uow, r, this.userid) : new IdentityAndPersonaPair(identity, persona);
                this.actuallyCreateDomain(uow, r, ip, this.domain);
            } else {
                if (!wktoken.equals(mytoken)) {
                    this.logger.error("domain creation for " + this.domain + " failed because " + wktoken + " did not match " + mytoken);
                }
                if (!this.domain.equals(reqdomain)) {
                    this.logger.error("domain creation for " + this.domain + " failed because " + this.domain + " did not match " + reqdomain);
                }
            }
        } else {
            if (this.domain == null) {
                this.logger.info("not creating domain because domain is NULL");
            }
            if (pd == null) {
                this.logger.info("not creating domain because pd is NULL");
            }
            if (wktoken == null) {
                this.logger.info("not creating domain because wktoken is NULL");
            }
        }
    }

    private IdentityAndPersona createUserThings(UnitOfWork uow, Relation r, String userid) {
        Credential cred = this.core.newCredential(uow, r, "cred", userid);
        IdentityAndPersona ip = this.core.newIdentity(uow, r, "identity", "persona");
        Identity id = ip.identity();
        this.logger.info("Created credential " + cred);
        this.logger.info("Created identity " + id);
        cred.setIdentity(id);
        id.addCredential((FLEvalContext)uow, cred);
        this.core.saveCredential(r, cred);
        return ip;
    }

    private Domain actuallyCreateDomain(UnitOfWork uow, Relation r, IdentityAndPersona ip, String domainName) {
        ZiId did = this.factory.unique("ziniki", domainName, "domain");
        JVMDomain d = new JVMDomain((FLEvalContext)uow, domainName, did, ip.identity(), ip.persona());
        r.create(did.toString(), (Object)d);
        this.ds.attachSecondaryKeyset((FLEvalContext)uow, new Object[]{did.toString(), "org.ziniki.DomainKey", new FailUOWHandler(uow)});
        ZiId aaId = this.factory.simple("data", domainName, "arena", "apps");
        JVMArena appArena = new JVMArena((FLEvalContext)uow);
        r.create(aaId.toString(), (Object)appArena);
        r.load("apparena-" + domainName, (Object)appArena);
        this.ds.attachSecondaryKeyset((FLEvalContext)uow, new Object[]{aaId.toString(), new TypeOf(PackageByName.class), new FailUOWHandler(uow)});
        this.ds.attachSecondaryKeyset((FLEvalContext)uow, new Object[]{aaId.toString(), new TypeOf(PackageByNameVersion.class), new FailUOWHandler(uow)});
        return d;
    }

    public void sendReply(UnitOfWork uow, Relation r, TxError e, Responder resp) throws IOException, TemplateException {
        this.success &= e == null;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("domain", this.domain);
        props.put("success", this.success);
        props.put("userid", this.userid);
        this.te.sendResource(resp, "domainCreated.fm", props);
        resp.done();
    }

    public Domain createDomainOnDemand(UnitOfWork uow, Relation r, String domainName, String initialUser) {
        IdentityAndPersona ip = this.createUserThings(uow, r, initialUser);
        return this.actuallyCreateDomain(uow, r, ip, domainName);
    }

    public void createUserInDomain(UnitOfWork uow, Relation r, Domain domain, String user) {
        this.createUserThings(uow, r, user);
    }

    static {
        String tostr = System.getenv("ZINIKI_UOW_TIMEOUT");
        if (tostr == null) {
            tostr = System.getProperty("ziniki.uow.timeout");
        }
        UOW_TIMEOUT = tostr != null ? Integer.parseInt(tostr) : 5000;
    }
}

