/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashMap;
import org.flasck.jvm.FLEvalContext;
import org.openid4java.consumer.ConsumerManager;
import org.ziniki.core.ZinikiCore;
import org.ziniki.core.concepts.Credential;
import org.ziniki.core.concepts.Identity;
import org.ziniki.interfaces.CredState;
import org.ziniki.interfaces.SecurityStore;
import org.ziniki.interfaces.TemplateEngine;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.servlet.Security;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.utils.IRandom;

public class AdditionalLogin
extends Security
implements RequestPathParameters {
    private String old;
    private final String loginCompleteUrl;

    public AdditionalLogin(@Param(value="zinikiUri") String zinikiUrl, @Param(value="random") IRandom random, @Param(value="consumerManager") ConsumerManager consumer, @Param(value="txmanager") TxManager txmgr, @Param(value="storage") TDAStorage storage, @Param(value="core") ZinikiCore core, @Param(value="securityStore") SecurityStore securityStore, @Param(value="templateEngine") TemplateEngine te, @Param(value="idfactory") ZiIdFactory factory) {
        super(random, consumer, txmgr, core, securityStore, te, factory);
        this.loginCompleteUrl = zinikiUrl + "/loginComplete";
    }

    @Override
    public void stringValue(String name, String value, ParameterSource source) {
        if (name.equals("old")) {
            this.old = value;
        }
    }

    public void process(Responder resp) throws IOException, GLSException {
        super.before(resp);
        try {
            if (this.isGet()) {
                this.r.logic("forkAdditionalLogin");
            } else if (this.isPost()) {
                this.r.logic("joinUsers");
            } else {
                this.r.logic("send405");
            }
            super.after(resp);
        }
        catch (Exception ex) {
            super.handleException(resp, ex);
        }
    }

    public void forkAdditionalLogin(Responder resp) throws IOException, TemplateException, GLSException {
        this.setNewUserId();
        this.r.logic("sendResourceAfterGeneratingCookie");
    }

    public void sendResourceAfterGeneratingCookie(Responder resp, @Slot(value="generated_userid") String dependencyOnGeneratingCookie) throws IOException, TemplateException {
        this.te.sendResource(resp, "spawnLogin.fm", new HashMap());
    }

    public void joinUsers(Responder resp) throws IOException, NotReadyException, GLSException {
        this.securityStore.getTokenState(this.r, "newstate", this.userid);
        this.r.logic("handleNewState");
    }

    public void handleNewState(Responder resp, @Slot(value="newstate") CredState cs) throws IOException, NotReadyException, GLSException {
        if (cs != CredState.WELLKNOWN) {
            this.logger.info("cookie " + this.userid + " was not registered");
            resp.setStatus(409);
            resp.write("Cannot join to a user who is not registered\n", null);
            return;
        }
        if (this.old == null || this.old.length() < 1) {
            this.logger.info("no valid session id was passed in as argument to join");
            resp.setStatus(404);
            return;
        }
        this.securityStore.getTokenState(this.r, "oldstate", this.old);
        this.r.logic("handleOldState");
        this.securityStore.getCredentialFor(this.r, "desiredCred", this.old);
        this.securityStore.getIdentityFor(this.r, "identityId", this.userid);
        this.r.logic("doTheJoin");
    }

    public void handleOldState(Responder resp, @Slot(value="oldstate") CredState newOne, @Slot(value="identityId") ZiId idid) throws IOException, NotReadyException {
        if (newOne != CredState.REGISTERING) {
            this.logger.info("pending token " + this.userid + " was not in registering state");
            resp.setStatus(409);
            resp.write("Cannot register a user who is already registered\n", null);
            return;
        }
        this.securityStore.getCredentialFor(this.r, "oldCred", this.old);
        this.securityStore.getIdentity(this.r, "identity", idid);
    }

    public void doTheJoin(UnitOfWork uow, Relation r, Responder resp, @Slot(value="desiredCred") String desiredCred, @Slot(value="identity") Identity id) throws IOException {
        try {
            Credential cred = this.core.newCredential(uow, r, "newCred", desiredCred);
            this.logger.info("Have existing credential " + cred);
            this.logger.info("Have existing identity " + id.ziid());
            cred.setIdentity(id);
            id.addCredential((FLEvalContext)uow, cred);
            r.update(cred.id(), (Object)cred);
            r.update(id.ziid().toString(), (Object)id);
            this.redirectTo(this.loginCompleteUrl);
        }
        catch (Exception ex) {
            this.handleException(resp, ex);
        }
    }

    public void hasSegment(String segment) {
        throw new NotImplementedException();
    }

    public void integerValue(String name, int value, ParameterSource source) {
        throw new NotImplementedException();
    }

    public void doubleValue(String name, double value, ParameterSource source) {
        throw new NotImplementedException();
    }
}

