/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.coreimpl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.common.UOWHost;
import org.ziniki.common.ZiIdURI;
import org.ziniki.core.ZinikiCore;
import org.ziniki.core.concepts.Credential;
import org.ziniki.core.concepts.IdentityAndPersona;
import org.ziniki.core.fl.IdentityAndPersonaPair;
import org.ziniki.core.fl.IdentityOnBench;
import org.ziniki.core.fl.JVMArena;
import org.ziniki.core.fl.JVMBench;
import org.ziniki.core.fl.JVMCredential;
import org.ziniki.core.fl.JVMIdentity;
import org.ziniki.core.fl.JVMPersona;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.paas.interfaces.EntityLink;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.WrappedException;

public class ZinikiServer
implements ZinikiCore {
    private final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    public static ZinikiServer instance;
    private ZiIdFactory factory;

    public ZinikiServer(@Param(value="idfactory") ZiIdFactory factory) {
        this(factory, false);
    }

    public ZinikiServer(ZiIdFactory factory, boolean embedded) {
        this.factory = factory;
        if (!embedded) {
            if (instance != null) {
                throw new RuntimeException("Multiple ZinikiServer instances created");
            }
            instance = this;
        }
    }

    public Credential newCredential(UnitOfWork uow, Relation r, String slot, String cred) {
        GLUnitOfWork zu = (GLUnitOfWork)uow;
        try {
            ZiId id = this.factory.simple("security", "cross.domain", "credential", URLEncoder.encode(cred, "UTF-8"));
            this.logger.info("creating credential for " + cred + " with id " + id);
            JVMCredential obj = new JVMCredential((FLEvalContext)zu);
            obj.setName(cred);
            r.load(slot, (Object)obj);
            r.create(id.toString(), (Object)obj);
            return obj;
        }
        catch (UnsupportedEncodingException e) {
            zu.fatalError((Throwable)e);
            throw WrappedException.wrap((Throwable)e);
        }
    }

    public void saveCredential(Relation r, Credential cred) {
        String id = cred.id();
        r.update(id, (Object)cred);
    }

    public IdentityAndPersona newIdentity(UnitOfWork uow, Relation r, String idSlot, String personaSlot) {
        GLUnitOfWork zu = (GLUnitOfWork)uow;
        String host = ((UOWHost)zu.trait(UOWHost.class)).host;
        ZiId identityID = this.factory.nextInSequence("ziniki", host, "identity");
        this.logger.info("creating new identity " + identityID);
        ZiId personaID = this.factory.nextInSequence("ziniki", host, "persona");
        this.logger.info("creating new persona " + personaID);
        ZiId arenaID = this.factory.nextInSequence("data", host, "arena");
        this.logger.info("creating new personal arena " + arenaID);
        JVMPersona persona = new JVMPersona((FLEvalContext)zu);
        JVMIdentity identity = new JVMIdentity((FLEvalContext)zu);
        JVMArena arena = new JVMArena((FLEvalContext)zu);
        ZiIdURI benchID = ((ZiIdURI)arenaID).makeType("bench").append("me");
        JVMBench bench = new JVMBench((FLEvalContext)zu, (ZiId)benchID, "me");
        bench.provideID(bench.id());
        arena.addBench(bench);
        identity.set("rootPersona", personaID);
        identity.set("personalArena", arenaID);
        r.create(identityID.toString(), (Object)identity);
        r.create(personaID.toString(), (Object)persona);
        r.create(arenaID.toString(), (Object)arena);
        r.link((EntityLink)new IdentityOnBench(identityID, bench.ziid(), personaID));
        r.load(idSlot, (Object)identity);
        r.load(personaSlot, (Object)persona);
        return new IdentityAndPersonaPair(identity, persona);
    }

    public void getPersona(Relation r, String slot, ZiId rootPersona) {
        r.get(slot, rootPersona.toString());
    }

    public static void destroy() {
        instance = null;
    }
}

